
----------------------------------------------------------------
--
-- Table creation scripts for class gene
--

----------------------------------------------------------------
--
-- Schema
--

----------------------------------------------------------------
--
-- Main table - gene
--
CREATE TABLE gene
	(
		id                               	VARCHAR(32)	NOT NULL PRIMARY KEY,
		geneid                           	VARCHAR(255),
		chrom_position                   	VARCHAR(255),
		chromosome                       	VARCHAR(255),
		contig                           	VARCHAR(255),
		end_pos                          	VARCHAR(255),
		gene                             	VARCHAR(255),
		name                             	VARCHAR(255),
		organism                         	VARCHAR(255),
		start_pos                        	VARCHAR(255),
		strand                           	VARCHAR(255),
		taxid                            	VARCHAR(255),
		type                             	VARCHAR(255)
	)
;

----------------------------------------------------------------
--
-- Multivalue field - gene_db_xref
--
CREATE TABLE gene_db_xref
	(
		id                               	VARCHAR(32)	NOT NULL,
		db_xref                          	VARCHAR(255)
	)
;
CREATE INDEX gene_db_xref_id_index ON gene_db_xref (id);

----------------------------------------------------------------
--
-- Multivalue field - gene_exons
--
CREATE TABLE gene_exons
	(
		id                               	VARCHAR(32)	NOT NULL,
		exons                            	VARCHAR(255)
	)
;
CREATE INDEX gene_exons_id_index ON gene_exons (id);

----------------------------------------------------------------
--
-- Multivalue field - gene_gene_synonym
--
CREATE TABLE gene_gene_synonym
	(
		id                               	VARCHAR(32)	NOT NULL,
		gene_synonym                     	VARCHAR(255)
	)
;
CREATE INDEX gene_gene_synonym_id_index ON gene_gene_synonym (id);

----------------------------------------------------------------
--
-- Multivalue field - gene_introns
--
CREATE TABLE gene_introns
	(
		id                               	VARCHAR(32)	NOT NULL,
		introns                          	VARCHAR(255)
	)
;
CREATE INDEX gene_introns_id_index ON gene_introns (id);

----------------------------------------------------------------
--
-- Multivalue field - gene_locus_tag
--
CREATE TABLE gene_locus_tag
	(
		id                               	VARCHAR(32)	NOT NULL,
		locus_tag                        	VARCHAR(255)
	)
;
CREATE INDEX gene_locus_tag_id_index ON gene_locus_tag (id);

----------------------------------------------------------------
--
-- Multivalue field - gene_names
--
CREATE TABLE gene_names
	(
		id                               	VARCHAR(32)	NOT NULL,
		names                            	VARCHAR(255),
		qualifier                        	VARCHAR(20)
	)
;
CREATE INDEX gene_names_id_index ON gene_names (id);

----------------------------------------------------------------
--
-- Multivalue field - gene_note
--
CREATE TABLE gene_note
	(
		id                               	VARCHAR(32)	NOT NULL,
		note                             	VARCHAR(255)
	)
;
CREATE INDEX gene_note_id_index ON gene_note (id);
