
usage:
	@perl -ne 'if (/^([a-z]\S+):/){ print "\t$$1\n";  }' misc_feature.mk

all: create alter load recompress

uncompress:
	gunzip -f ../../misc_feature*.tab.gz

recompress:
	gzip -f ../../misc_feature*.tab

create:
	@echo "--- Creating misc_feature"
	psql -f misc_feature_table_create.sql -d rsat

alter:
	@echo "--- Alter misc_feature"
	psql -f misc_feature_table_alter.sql -d rsat

load:
	@echo "--- Loading misc_feature"
	grep -v '^--' ../../misc_feature.tab | psql -f misc_feature_table_load.ctl -d rsat
	grep -v '^--' ../../misc_feature_db_xref.tab | psql -f misc_feature_db_xref_table_load.ctl -d rsat
	grep -v '^--' ../../misc_feature_function.tab | psql -f misc_feature_function_table_load.ctl -d rsat
	grep -v '^--' ../../misc_feature_names.tab | psql -f misc_feature_names_table_load.ctl -d rsat
	grep -v '^--' ../../misc_feature_note.tab | psql -f misc_feature_note_table_load.ctl -d rsat

drop:
	@echo "--- Dropping misc_feature"
	psql -f misc_feature_table_drop.sql -d rsat
