
usage:
	@perl -ne 'if (/^([a-z]\S+):/){ print "\t$$1\n";  }' misc_rna.mk

all: create alter load recompress

uncompress:
	gunzip -f ../../misc_rna*.tab.gz

recompress:
	gzip -f ../../misc_rna*.tab

create:
	@echo "--- Creating misc_rna"
	psql -f misc_rna_table_create.sql -d rsat

alter:
	@echo "--- Alter misc_rna"
	psql -f misc_rna_table_alter.sql -d rsat

load:
	@echo "--- Loading misc_rna"
	grep -v '^--' ../../misc_rna.tab | psql -f misc_rna_table_load.ctl -d rsat
	grep -v '^--' ../../misc_rna_function.tab | psql -f misc_rna_function_table_load.ctl -d rsat
	grep -v '^--' ../../misc_rna_names.tab | psql -f misc_rna_names_table_load.ctl -d rsat
	grep -v '^--' ../../misc_rna_note.tab | psql -f misc_rna_note_table_load.ctl -d rsat

drop:
	@echo "--- Dropping misc_rna"
	psql -f misc_rna_table_drop.sql -d rsat
