
usage:
	@perl -ne 'if (/^([a-z]\S+):/){ print "\t$$1\n";  }' mrna.mk

all: create alter load recompress

uncompress:
	gunzip -f ../../mrna*.tab.gz

recompress:
	gzip -f ../../mrna*.tab

create:
	@echo "--- Creating mrna"
	psql -f mrna_table_create.sql -d rsat

alter:
	@echo "--- Alter mrna"
	psql -f mrna_table_alter.sql -d rsat

load:
	@echo "--- Loading mrna"
	grep -v '^--' ../../mrna.tab | psql -f mrna_table_load.ctl -d rsat
	grep -v '^--' ../../mrna_db_xref.tab | psql -f mrna_db_xref_table_load.ctl -d rsat
	grep -v '^--' ../../mrna_exons.tab | psql -f mrna_exons_table_load.ctl -d rsat
	grep -v '^--' ../../mrna_gene_synonym.tab | psql -f mrna_gene_synonym_table_load.ctl -d rsat
	grep -v '^--' ../../mrna_introns.tab | psql -f mrna_introns_table_load.ctl -d rsat
	grep -v '^--' ../../mrna_locus_tag.tab | psql -f mrna_locus_tag_table_load.ctl -d rsat
	grep -v '^--' ../../mrna_names.tab | psql -f mrna_names_table_load.ctl -d rsat
	grep -v '^--' ../../mrna_note.tab | psql -f mrna_note_table_load.ctl -d rsat

drop:
	@echo "--- Dropping mrna"
	psql -f mrna_table_drop.sql -d rsat
