
usage:
	@perl -ne 'if (/^([a-z]\S+):/){ print "\t$$1\n";  }' organism.mk

all: create alter load recompress

uncompress:
	gunzip -f ../../organism*.tab.gz

recompress:
	gzip -f ../../organism*.tab

create:
	@echo "--- Creating organism"
	psql -f organism_table_create.sql -d rsat

alter:
	@echo "--- Alter organism"
	psql -f organism_table_alter.sql -d rsat

load:
	@echo "--- Loading organism"
	grep -v '^--' ../../organism.tab | psql -f organism_table_load.ctl -d rsat

drop:
	@echo "--- Dropping organism"
	psql -f organism_table_drop.sql -d rsat
