
usage:
	@perl -ne 'if (/^([a-z]\S+):/){ print "\t$$1\n";  }' repeat_region.mk

all: create alter load recompress

uncompress:
	gunzip -f ../../repeat_region*.tab.gz

recompress:
	gzip -f ../../repeat_region*.tab

create:
	@echo "--- Creating repeat_region"
	psql -f repeat_region_table_create.sql -d rsat

alter:
	@echo "--- Alter repeat_region"
	psql -f repeat_region_table_alter.sql -d rsat

load:
	@echo "--- Loading repeat_region"
	grep -v '^--' ../../repeat_region.tab | psql -f repeat_region_table_load.ctl -d rsat
	grep -v '^--' ../../repeat_region_db_xref.tab | psql -f repeat_region_db_xref_table_load.ctl -d rsat
	grep -v '^--' ../../repeat_region_note.tab | psql -f repeat_region_note_table_load.ctl -d rsat
	grep -v '^--' ../../repeat_region_rpt_family.tab | psql -f repeat_region_rpt_family_table_load.ctl -d rsat

drop:
	@echo "--- Dropping repeat_region"
	psql -f repeat_region_table_drop.sql -d rsat
