
----------------------------------------------------------------
--
-- Table creation scripts for class repeat_region
--

----------------------------------------------------------------
--
-- Schema
--

----------------------------------------------------------------
--
-- Main table - repeat_region
--
CREATE TABLE repeat_region
	(
		id                               	VARCHAR(32)	NOT NULL PRIMARY KEY,
		chrom_position                   	VARCHAR(255),
		chromosome                       	VARCHAR(255),
		contig                           	VARCHAR(255),
		end_pos                          	VARCHAR(255),
		organism                         	VARCHAR(255),
		start_pos                        	VARCHAR(255),
		strand                           	VARCHAR(255),
		taxid                            	VARCHAR(255),
		type                             	VARCHAR(255)
	)
;

----------------------------------------------------------------
--
-- Multivalue field - repeat_region_db_xref
--
CREATE TABLE repeat_region_db_xref
	(
		id                               	VARCHAR(32)	NOT NULL,
		db_xref                          	VARCHAR(255)
	)
;
CREATE INDEX repeat_region_db_xref_id_index ON repeat_region_db_xref (id);

----------------------------------------------------------------
--
-- Multivalue field - repeat_region_note
--
CREATE TABLE repeat_region_note
	(
		id                               	VARCHAR(32)	NOT NULL,
		note                             	VARCHAR(255)
	)
;
CREATE INDEX repeat_region_note_id_index ON repeat_region_note (id);

----------------------------------------------------------------
--
-- Multivalue field - repeat_region_rpt_family
--
CREATE TABLE repeat_region_rpt_family
	(
		id                               	VARCHAR(32)	NOT NULL,
		rpt_family                       	VARCHAR(255)
	)
;
CREATE INDEX repeat_region_rpt_family_id_index ON repeat_region_rpt_family (id);
