
usage:
	@perl -ne 'if (/^([a-z]\S+):/){ print "\t$$1\n";  }' rrna.mk

all: create alter load recompress

uncompress:
	gunzip -f ../../rrna*.tab.gz

recompress:
	gzip -f ../../rrna*.tab

create:
	@echo "--- Creating rrna"
	psql -f rrna_table_create.sql -d rsat

alter:
	@echo "--- Alter rrna"
	psql -f rrna_table_alter.sql -d rsat

load:
	@echo "--- Loading rrna"
	grep -v '^--' ../../rrna.tab | psql -f rrna_table_load.ctl -d rsat
	grep -v '^--' ../../rrna_db_xref.tab | psql -f rrna_db_xref_table_load.ctl -d rsat
	grep -v '^--' ../../rrna_function.tab | psql -f rrna_function_table_load.ctl -d rsat
	grep -v '^--' ../../rrna_locus_tag.tab | psql -f rrna_locus_tag_table_load.ctl -d rsat
	grep -v '^--' ../../rrna_names.tab | psql -f rrna_names_table_load.ctl -d rsat
	grep -v '^--' ../../rrna_note.tab | psql -f rrna_note_table_load.ctl -d rsat

drop:
	@echo "--- Dropping rrna"
	psql -f rrna_table_drop.sql -d rsat
