
usage:
	@perl -ne 'if (/^([a-z]\S+):/){ print "\t$$1\n";  }' scrna.mk

all: create alter load recompress

uncompress:
	gunzip -f ../../scrna*.tab.gz

recompress:
	gzip -f ../../scrna*.tab

create:
	@echo "--- Creating scrna"
	psql -f scrna_table_create.sql -d rsat

alter:
	@echo "--- Alter scrna"
	psql -f scrna_table_alter.sql -d rsat

load:
	@echo "--- Loading scrna"
	grep -v '^--' ../../scrna.tab | psql -f scrna_table_load.ctl -d rsat
	grep -v '^--' ../../scrna_db_xref.tab | psql -f scrna_db_xref_table_load.ctl -d rsat
	grep -v '^--' ../../scrna_note.tab | psql -f scrna_note_table_load.ctl -d rsat

drop:
	@echo "--- Dropping scrna"
	psql -f scrna_table_drop.sql -d rsat
