
usage:
	@perl -ne 'if (/^([a-z]\S+):/){ print "\t$$1\n";  }' source.mk

all: create alter load recompress

uncompress:
	gunzip -f ../../source*.tab.gz

recompress:
	gzip -f ../../source*.tab

create:
	@echo "--- Creating source"
	psql -f source_table_create.sql -d rsat

alter:
	@echo "--- Alter source"
	psql -f source_table_alter.sql -d rsat

load:
	@echo "--- Loading source"
	grep -v '^--' ../../source.tab | psql -f source_table_load.ctl -d rsat
	grep -v '^--' ../../source_db_xref.tab | psql -f source_db_xref_table_load.ctl -d rsat
	grep -v '^--' ../../source_mol_type.tab | psql -f source_mol_type_table_load.ctl -d rsat
	grep -v '^--' ../../source_note.tab | psql -f source_note_table_load.ctl -d rsat
	grep -v '^--' ../../source_organelle.tab | psql -f source_organelle_table_load.ctl -d rsat
	grep -v '^--' ../../source_transl_except.tab | psql -f source_transl_except_table_load.ctl -d rsat

drop:
	@echo "--- Dropping source"
	psql -f source_table_drop.sql -d rsat
