
----------------------------------------------------------------
--
-- Table creation scripts for class source
--

----------------------------------------------------------------
--
-- Schema
--

----------------------------------------------------------------
--
-- Main table - source
--
CREATE TABLE source
	(
		id                               	VARCHAR(32)	NOT NULL PRIMARY KEY,
		chrom_position                   	VARCHAR(255),
		chromosome                       	VARCHAR(255),
		contig                           	VARCHAR(255),
		isolate                          	VARCHAR(255),
		organism                         	VARCHAR(255),
		plasmid                          	VARCHAR(255),
		serotype                         	VARCHAR(255),
		strain                           	VARCHAR(255),
		sub_strain                       	VARCHAR(255),
		taxid                            	VARCHAR(255),
		type                             	VARCHAR(255)
	)
;

----------------------------------------------------------------
--
-- Multivalue field - source_db_xref
--
CREATE TABLE source_db_xref
	(
		id                               	VARCHAR(32)	NOT NULL,
		db_xref                          	VARCHAR(255)
	)
;
CREATE INDEX source_db_xref_id_index ON source_db_xref (id);

----------------------------------------------------------------
--
-- Multivalue field - source_mol_type
--
CREATE TABLE source_mol_type
	(
		id                               	VARCHAR(32)	NOT NULL,
		mol_type                         	VARCHAR(255)
	)
;
CREATE INDEX source_mol_type_id_index ON source_mol_type (id);

----------------------------------------------------------------
--
-- Multivalue field - source_note
--
CREATE TABLE source_note
	(
		id                               	VARCHAR(32)	NOT NULL,
		note                             	VARCHAR(255)
	)
;
CREATE INDEX source_note_id_index ON source_note (id);

----------------------------------------------------------------
--
-- Multivalue field - source_organelle
--
CREATE TABLE source_organelle
	(
		id                               	VARCHAR(32)	NOT NULL,
		organelle                        	VARCHAR(255)
	)
;
CREATE INDEX source_organelle_id_index ON source_organelle (id);

----------------------------------------------------------------
--
-- Multivalue field - source_transl_except
--
CREATE TABLE source_transl_except
	(
		id                               	VARCHAR(32)	NOT NULL,
		transl_except                    	VARCHAR(255)
	)
;
CREATE INDEX source_transl_except_id_index ON source_transl_except (id);
