
usage:
	@perl -ne 'if (/^([a-z]\S+):/){ print "\t$$1\n";  }' trna.mk

all: create alter load recompress

uncompress:
	gunzip -f ../../trna*.tab.gz

recompress:
	gzip -f ../../trna*.tab

create:
	@echo "--- Creating trna"
	psql -f trna_table_create.sql -d rsat

alter:
	@echo "--- Alter trna"
	psql -f trna_table_alter.sql -d rsat

load:
	@echo "--- Loading trna"
	grep -v '^--' ../../trna.tab | psql -f trna_table_load.ctl -d rsat
	grep -v '^--' ../../trna_db_xref.tab | psql -f trna_db_xref_table_load.ctl -d rsat
	grep -v '^--' ../../trna_exons.tab | psql -f trna_exons_table_load.ctl -d rsat
	grep -v '^--' ../../trna_function.tab | psql -f trna_function_table_load.ctl -d rsat
	grep -v '^--' ../../trna_introns.tab | psql -f trna_introns_table_load.ctl -d rsat
	grep -v '^--' ../../trna_locus_tag.tab | psql -f trna_locus_tag_table_load.ctl -d rsat
	grep -v '^--' ../../trna_names.tab | psql -f trna_names_table_load.ctl -d rsat
	grep -v '^--' ../../trna_note.tab | psql -f trna_note_table_load.ctl -d rsat

drop:
	@echo "--- Dropping trna"
	psql -f trna_table_drop.sql -d rsat
