MYSQL=mysql -u rsat -D rsat -prsat -h rsat.ulb.ac.be

usage:
	@perl -ne 'if (/^([a-z]\S+):/){ print "\t$$1\n";  }' rrna.mk

all: uncompress create load recompress

uncompress:
	gunzip -f ../rRNA*.tab.gz

recompress:
	gzip -f ../rRNA*.tab

create:
	@echo "--- Creating rrna"
	cat rrna_table_create.sql | ${MYSQL}

load:
	@echo "--- Loading rRNA"
	grep -v '^--' ../rRNA.tab > ../rRNA_filtered.tab
	cat rrna_table_load.ctl | ${MYSQL}
	rm ../rRNA_filtered.tab
	grep -v '^--' ../rRNA_function.tab > ../rRNA_function_filtered.tab
	cat rrna_function_table_load.ctl | ${MYSQL}
	rm ../rRNA_function_filtered.tab
	grep -v '^--' ../rRNA_evidence.tab > ../rRNA_evidence_filtered.tab
	cat rrna_evidence_table_load.ctl | ${MYSQL}
	rm ../rRNA_evidence_filtered.tab
	grep -v '^--' ../rRNA_names.tab > ../rRNA_names_filtered.tab
	cat rrna_names_table_load.ctl | ${MYSQL}
	rm ../rRNA_names_filtered.tab
	grep -v '^--' ../rRNA_note.tab > ../rRNA_note_filtered.tab
	cat rrna_note_table_load.ctl | ${MYSQL}
	rm ../rRNA_note_filtered.tab
	grep -v '^--' ../rRNA_db_xref.tab > ../rRNA_db_xref_filtered.tab
	cat rrna_db_xref_table_load.ctl | ${MYSQL}
	rm ../rRNA_db_xref_filtered.tab

drop:
	@echo "--- Dropping rrna"
	cat rrna_table_drop.sql | ${MYSQL}
