
----------------------------------------------------------------
--
-- Table creation scripts for class rrna
--

----------------------------------------------------------------
--
-- Schema
--
use rsat;


----------------------------------------------------------------
--
-- Main table - rrna
--
CREATE TABLE rrna
	(
		id                               	VARCHAR(16)	NOT NULL,
		gene                             	VARCHAR(255),
		start_pos                        	VARCHAR(255),
		taxid                            	VARCHAR(255),
		chrom_position                   	VARCHAR(255),
		chromosome                       	VARCHAR(255),
		strand                           	VARCHAR(255),
		organism                         	VARCHAR(255),
		contig                           	VARCHAR(255),
		gene_id                          	VARCHAR(255),
		end_pos                          	VARCHAR(255),
		name                             	VARCHAR(255),
		product                          	VARCHAR(255),
		type                             	VARCHAR(255)
	)
;

----------------------------------------------------------------
--
-- Multivalue field - rrna_function
--
CREATE TABLE rrna_function
	(
		id                               	VARCHAR(16)	NOT NULL,
		function                         	VARCHAR(255)
	)
;

----------------------------------------------------------------
--
-- Multivalue field - rrna_evidence
--
CREATE TABLE rrna_evidence
	(
		id                               	VARCHAR(16)	NOT NULL,
		evidence                         	VARCHAR(255)
	)
;

----------------------------------------------------------------
--
-- Multivalue field - rrna_names
--
CREATE TABLE rrna_names
	(
		id                               	VARCHAR(16)	NOT NULL,
		names                            	VARCHAR(255),
		qualifier                        	VARCHAR(20)
	)
;

----------------------------------------------------------------
--
-- Multivalue field - rrna_note
--
CREATE TABLE rrna_note
	(
		id                               	VARCHAR(16)	NOT NULL,
		note                             	VARCHAR(255)
	)
;

----------------------------------------------------------------
--
-- Multivalue field - rrna_db_xref
--
CREATE TABLE rrna_db_xref
	(
		id                               	VARCHAR(16)	NOT NULL,
		db_xref                          	VARCHAR(255)
	)
;
