MYSQL=mysql -u rsat -D rsat -prsat -h rsat.ulb.ac.be

usage:
	@perl -ne 'if (/^([a-z]\S+):/){ print "\t$$1\n";  }' source.mk

all: uncompress create load recompress

uncompress:
	gunzip -f ../Source*.tab.gz

recompress:
	gzip -f ../Source*.tab

create:
	@echo "--- Creating source"
	cat source_table_create.sql | ${MYSQL}

load:
	@echo "--- Loading Source"
	grep -v '^--' ../Source.tab > ../Source_filtered.tab
	cat source_table_load.ctl | ${MYSQL}
	rm ../Source_filtered.tab
	grep -v '^--' ../Source_transl_except.tab > ../Source_transl_except_filtered.tab
	cat source_transl_except_table_load.ctl | ${MYSQL}
	rm ../Source_transl_except_filtered.tab
	grep -v '^--' ../Source_organelle.tab > ../Source_organelle_filtered.tab
	cat source_organelle_table_load.ctl | ${MYSQL}
	rm ../Source_organelle_filtered.tab
	grep -v '^--' ../Source_note.tab > ../Source_note_filtered.tab
	cat source_note_table_load.ctl | ${MYSQL}
	rm ../Source_note_filtered.tab
	grep -v '^--' ../Source_db_xref.tab > ../Source_db_xref_filtered.tab
	cat source_db_xref_table_load.ctl | ${MYSQL}
	rm ../Source_db_xref_filtered.tab

drop:
	@echo "--- Dropping source"
	cat source_table_drop.sql | ${MYSQL}
