MYSQL=mysql -u rsat -D rsat -prsat -h rsat.ulb.ac.be

usage:
	@perl -ne 'if (/^([a-z]\S+):/){ print "\t$$1\n";  }' trna.mk

all: uncompress create load recompress

uncompress:
	gunzip -f ../tRNA*.tab.gz

recompress:
	gzip -f ../tRNA*.tab

create:
	@echo "--- Creating trna"
	cat trna_table_create.sql | ${MYSQL}

load:
	@echo "--- Loading tRNA"
	grep -v '^--' ../tRNA.tab > ../tRNA_filtered.tab
	cat trna_table_load.ctl | ${MYSQL}
	rm ../tRNA_filtered.tab
	grep -v '^--' ../tRNA_function.tab > ../tRNA_function_filtered.tab
	cat trna_function_table_load.ctl | ${MYSQL}
	rm ../tRNA_function_filtered.tab
	grep -v '^--' ../tRNA_evidence.tab > ../tRNA_evidence_filtered.tab
	cat trna_evidence_table_load.ctl | ${MYSQL}
	rm ../tRNA_evidence_filtered.tab
	grep -v '^--' ../tRNA_exons.tab > ../tRNA_exons_filtered.tab
	cat trna_exons_table_load.ctl | ${MYSQL}
	rm ../tRNA_exons_filtered.tab
	grep -v '^--' ../tRNA_introns.tab > ../tRNA_introns_filtered.tab
	cat trna_introns_table_load.ctl | ${MYSQL}
	rm ../tRNA_introns_filtered.tab
	grep -v '^--' ../tRNA_names.tab > ../tRNA_names_filtered.tab
	cat trna_names_table_load.ctl | ${MYSQL}
	rm ../tRNA_names_filtered.tab
	grep -v '^--' ../tRNA_note.tab > ../tRNA_note_filtered.tab
	cat trna_note_table_load.ctl | ${MYSQL}
	rm ../tRNA_note_filtered.tab
	grep -v '^--' ../tRNA_db_xref.tab > ../tRNA_db_xref_filtered.tab
	cat trna_db_xref_table_load.ctl | ${MYSQL}
	rm ../tRNA_db_xref_filtered.tab

drop:
	@echo "--- Dropping trna"
	cat trna_table_drop.sql | ${MYSQL}
