
----------------------------------------------------------------
--
-- Table creation scripts for class trna
--

----------------------------------------------------------------
--
-- Schema
--
use rsat;


----------------------------------------------------------------
--
-- Main table - trna
--
CREATE TABLE trna
	(
		id                               	VARCHAR(16)	NOT NULL,
		gene                             	VARCHAR(255),
		start_pos                        	VARCHAR(255),
		taxid                            	VARCHAR(255),
		chrom_position                   	VARCHAR(255),
		chromosome                       	VARCHAR(255),
		strand                           	VARCHAR(255),
		organism                         	VARCHAR(255),
		contig                           	VARCHAR(255),
		gene_id                          	VARCHAR(255),
		end_pos                          	VARCHAR(255),
		name                             	VARCHAR(255),
		product                          	VARCHAR(255),
		type                             	VARCHAR(255)
	)
;

----------------------------------------------------------------
--
-- Multivalue field - trna_function
--
CREATE TABLE trna_function
	(
		id                               	VARCHAR(16)	NOT NULL,
		function                         	VARCHAR(255)
	)
;

----------------------------------------------------------------
--
-- Multivalue field - trna_evidence
--
CREATE TABLE trna_evidence
	(
		id                               	VARCHAR(16)	NOT NULL,
		evidence                         	VARCHAR(255)
	)
;

----------------------------------------------------------------
--
-- Multivalue field - trna_exons
--
CREATE TABLE trna_exons
	(
		id                               	VARCHAR(16)	NOT NULL,
		exons                            	VARCHAR(255)
	)
;

----------------------------------------------------------------
--
-- Multivalue field - trna_introns
--
CREATE TABLE trna_introns
	(
		id                               	VARCHAR(16)	NOT NULL,
		introns                          	VARCHAR(255)
	)
;

----------------------------------------------------------------
--
-- Multivalue field - trna_names
--
CREATE TABLE trna_names
	(
		id                               	VARCHAR(16)	NOT NULL,
		names                            	VARCHAR(255),
		qualifier                        	VARCHAR(20)
	)
;

----------------------------------------------------------------
--
-- Multivalue field - trna_note
--
CREATE TABLE trna_note
	(
		id                               	VARCHAR(16)	NOT NULL,
		note                             	VARCHAR(255)
	)
;

----------------------------------------------------------------
--
-- Multivalue field - trna_db_xref
--
CREATE TABLE trna_db_xref
	(
		id                               	VARCHAR(16)	NOT NULL,
		db_xref                          	VARCHAR(255)
	)
;
