# Docker containers for the Regulatory Sequence Analysis Tools (RSAT)


This folder contains the installation scripts for the software suite
Regulatory Sequence Analysis Tools (RSAT; http://rsat.eu/).

The installation must be executed as root user. If you are non-root
but sudoer user, you can become it withn "sudo bash".



********************************************************************************
## Credits

- **François-Xavier Théodule**
- **Jacques van Helden** (<Jacques.van-Helden@univ-amu.fr>)

The RSAT instlaler bash script was developed under Ubuntu by Jacques
van Helden.

It was ported to Debian by FranÃ§ois-Xavier ThÃ©odule, who developed the
rsat\_debian docker image. Jacques van Helden developed the
rsat\_ubuntu image with the help of Olivier Sallou.


****************************************************************
## Installation procedure

## Requirements

If not done, install the latest version of docker: <https://docs.docker.com/>

## Loading a docker image from its mount point


```
docker load -i  Images/rsat_debian-2016-07-15.tar.gz

```

## Checking the available docker images

```
docker images
```

Example of result: 

```
REPOSITORY          TAG                 IMAGE ID            CREATED             SIZE
rsat-commands       2016-10-26          7055c53a521e        46 hours ago        4.543 GB
ubuntu              16.04               f753707788c5        2 weeks ago         127.2 MB
rsat_debian         2016-07-13          5021cd9759f6        3 months ago        1.804 GB
debian              jessie              1b088884749b        4 months ago        125.1 MB
rsat_debian         2016-07-13.prepa    1b088884749b        4 months ago        125.1 MB

```

## Start a container with the RSAT Web server

The following command sarts a container with an RSAT Web server visible at port 32801 of the local host.
The server has 1Gb RAM, and a mount point to a shared space folder on `/rsat_data`.


```
mkdir -p ~/rsat_data

docker run -t -i -m 1g  -v ~/rsat_data:/rsat_data -p 32801:80 rsat_debian:2016-07-15
```

The RSAT server can then be accessed from a Web browser, at URL <http://[host.ip.address]/:32801/rsat>.

If you are working directly on the host machine, the server should be
visible at **<http://localhost:32801/rsat>**. If you are connected
remotely, you need to know the external IP address of the host
machine. ^[Remote Web browsers will access the host via the port 80, and be redirected to the guest RSAT server (docker) on the port 32801. ]

Note that the Web server remains active in the active container, but is stopped when exiting this container.

## Running an RSAT command on the docker container since the host machine

executer une commande rsat depuis sa machine physique (volume partage entre conteneur et machine physique /RsatInstall et /tmp) via un conteneur

Ajouter en fin de ligne precedente( "docker run" ) la commande rsat a executer, ses parametres , fichiers d'entree et un emplacement de sortie de resultat .
A noter que dans ce cas le conteneur se referme automatiquement aprÃ¨s execution de la commande

Exemple : commande rsat /rsat/perl-scripts/retrieve-seq
Parametres -org Saccharomyces_cerevisiae -feattype gene -type upstream -format fasta -label name -from -800 -to -1
Fichier d'entree de la commande rsat :  /RsatInstall/list.genes (vu depuis le conteneur ou  /tmp/list.genes vu depuis l'hote hebergeur)
Fichier de sortie /tmp/output sur l'hote

docker run -t -i -m 1g  -v /tmp:/RsatInstall -p 32801:80 rsat_debian:3.1.0 /rsat/perl-scripts/retrieve-seq  -org Saccharomyces_cerevisiae -feattype gene -type upstream -format fasta -label name -from -800 -to -1 -i /RsatInstall/list.genes > /tmp/output

Avec un fichier d'entrÃ©e :
```
more /tmp/list.genes 
DAL5
GAP1
MEP1
MEP2
PUT4
MEP3
DAL80
```

On a un fichier de sortie  /tmp/output

```
root@Theodule-VBox-Clone:/home/tagc# more  /tmp/output
>DAL5   DAL5; upstream from -800 to -1; size: 800; feature type:gene; location: Saccharomyces_cerevisiae:NC_001142.7:718860:719659:D
GAACATCTGTTTAACTTTCAAGCTTTCTACCATATAGCCGAGATGAGCAAATACATTAAA
ACATCAAAAAGTGGTGCTTGAATGCTTATTTTATGACGCAAAGCAGATGTAATGCATCCC
GAGTAAAACAGAATACTTAATTTGACTTCAGCAAAATAACTACCCAGAATGAACACCGAA
TTTGACATTGATAACAAGACAATCTAGGAATACTTTTACATCAGCACAATATCCATGGTG
GATCCCGGCGGATTTTTCTTTCTTATTGCACCTTAATCAGGTTTACAGCCTATGACTGAC
TCTGGAGTGTCCTTTCCCAGTATCTGATTGTTTCCGCAACATCTATGCATATCAGAGAAG
CGTTCTCATCAGTCACTTGACAAATGCTCGAGGAGCTATCATTTGCTGATAAGGTGCTAC
AGCGCGCTCCTGCCGCACGCTTTGTTCCTTTTCGATAAGAGTCCCTCGCGTTAGTCTGAG
TGAAGTGCGGAATTCAGCAAACGAATAACAATCGACCTTATGATCATGTGGATTATCGGG
GCAAAAGATTTGGCCAAGATGTCAGAGAACGTTATCACCAATCACTCACACAATTAAGTG
GTAGTGTAACTCCGAAGATACGGCTAATACTTATCATTATCTGGTTTTCCGAATATACAG
ATTGGATGAAGTAATATATGTATATAAATGGACCAAGGAAACATCAAATTAGGAGATCAT
GAGGGAAAGGTTTAACATAACAACATTGAAGAAAACAACAAAACAAGGATAATCAAATAG
TGTAAAAAAAAAAATTCAAG
>GAP1   GAP1; upstream from -800 to -1; size: 800; feature type:gene; location: Saccharomyces_cerevisiae:NC_001143.7:513905:514704:D
CCTACAACAATAGATTAGACACACCAGTGCCAAGGACAATATGTTGCGTTCTGACTAGTC
GAAGTATCATTACGCTGTGCAGATCGACCTGACACCAGACACAAAGGAGAATAGGGGCAG
CATGAGTTCCGTCGGCGACTCATTCCGACCTTCCACAGGTCCGTTGATTACTTTTTCACT
GATCCGGTGGAATCTATGGTTGTTTTTTTCATCATGATATCTGTTTTAGGACTTTTTTTT
TCAGCCGATCGCTTATCTGCTCACTAGAATCGTAATCAGTGATATTTTTATTAATAATTA
TTATTTATTTTTTTTTATACCATTTCCTTTTGATAAGGGGTCGTTGGTGCCGTGCCGCTA
TCAGGCAGCCTCACTAATCTACCCATTGACCTCATGCAGCAAAGTCACATCGCCCATATC
TCTCGAGTGCGATAACGGGGAACTTGATTTGGTAACTGATAAGATTGTTAAATGTCAGTT
TGGATGCTTTTTCTTACGTCCGATTAGCTTATCTTCTGGAGCAACCGGCCATTTACCTCC
TCATAGTAAATTAAACATGATAAGCGCATAGTTGGGGCAACACACCTTTCTTCCGGAATT
CGCTCTGGATGAGACATATAAAGATGAAGGTGAAGTCCACTTAAATGAATGTCAATGAGA
CGATGTTTTTTCTCCTAGATTGATTTTTGAATTCCTTGTATACAAAGTCTTGTTTTCTTA
TTGTCCTCAACAAAACAAAAGTAGAAAAGAACAGACCAAGGACAGCAACATTTATAAGAA
ACAAAAAAAAGAAATAAAAA
>MEP1   MEP1; upstream from -800 to -1; size: 800; feature type:gene; location: Saccharomyces_cerevisiae:NC_001139.8:732933:733732:R
AGAGCTATTTGTAAGGGAAGACAAGATCTCAAGTGTTACCACAGCCCGTAATTGAGTTCG
GCACTATTCGAGCGCACAAAAAATCCCGTACTGTTTTTTTTCAGATAAGAAAGACTGAGC
CTATATAAACACTACCTGAACCATTTTTAAGATAAAAGTTATATACGATAGAGTTATCCC
CTCTTAATAATTGATCAAGAACCTCTGAAGCACAAAAGGGAGCATAAGAGCACTTAGGGA
CAAACGTATTTCTTTCCCCCACTCCCCTTTTTCCCTTTGCGATGCACATCCATAACTTGT
ACTTGTGTCTTGACATTCTTCAAAATCAACATGGCGATGCTCTTCTACGGTTGTCCTTTG
CCACGAACTTTGTTTTGCGCCTCCCCTCCCTTTGTCAGGCTGAGTGCAAAAGAAAAGGCC
CTGGTTGCTTATCTCTGCGGACACGCGCCCCTCTTATTGGATGAGACATCTCAGAGATTG
CGATAACGATAAGATTCACAATTGCTACAGACACCCTTGTGTGACATCTTATGGCTATGT
AAGCACAGAAGAGAAGAAGAAAGAAATGACAAAGTATTGATGGAAGATGTTTTTCCTGAA
AAAAAAAAAAAAAAAAAATCGGAAAAGTGGTGTAGGCTTCTATAGCACCTTCTGCTTACC
AGTCGATAATGCAGTTCCAGAATAAGATACTTAAAAGGTAGTTTATTTATATAGGCGCTC
TTGTAACTTGTTTAGGCTTATGATCAGAGAATTATTTTAGTAAACATAACTGCAGTACGG
ATTCTTATACTGTAGAAACT
>MEP2   MEP2; upstream from -800 to -1; size: 800; feature type:gene; location: Saccharomyces_cerevisiae:NC_001146.6:356655:357454:D
TGAGTTTTCTTTTTCTGATATTATTGGATAATATTTTCAGCTATAGACTATCATCATTCA
GCATTGGTCACGCTAAAATATACGTTCCATGCATACGTGATAGCCTACTCGGTTGTCAAC
TTCATTTTATAGGCTGCCTGGTCACCGATTACCGCCCCGCTCAGCAGGACGGTTTAAGCT
TCTGTTCTTGGAAACGACGTAATTCATGTCGGCCATCGAAATCATTCCTGGCTTTGTAAT
AGTCATAATGAACAAGGAATGCTGTCTTGGGTTTTTTTCCCTTTGCGAATACCCGGGCTG
CCAAAATAGAAAAGGAACAAATGGTAGGTCTTTAAGATAAGAAAGATAAGATAAGACATC
TTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTCCGATAACAAAGAAGAATCCTTCGGTCT
CTTCTTACTGCTGTTACTGCTTATCAAGAGTGTCTGGTAATAGTCAAAGCCAGATAAGAT
AAGAAATGTAAAATCGACTATTTCCCTCGTAAAAAGCTTCAATTGCTCACGCATCGACGA
ATACTAAGCGGCGTGAAGACCCTGTGCCTTATCAATGAAGTATTCAGTACAAGAGGTGTT
CATTCCGAGCCACTTTTCTGCACCATATATAAGCAGTAGTTACACATGTGCTAACCAAAC
ATCAGTGGGTAGTAATCATTCGTGCTTTCACGTCCTTTCAAATTAAATATCCTTCTTAAA
TAATAAGTCTGCACAGAGCTTTGAAAGAAGTTTAGTTTTGTAATATATCATACTTAATAT
ATTACAATACAATATCAACA
>PUT4   PUT4; upstream from -800 to -1; size: 800; feature type:gene; location: Saccharomyces_cerevisiae:NC_001147.5:988780:989579:R
TCTAAAACGGAGATCAAATACCGGGCCCGCGCGCGATGGCCGGATGTCCGTCCATACTGC
AATGTGAATTCCCGCGCGGTTCAAATCTTGTCACAAGTTTGTCAAAATTGCTTGTCATGT
CTGCCAAATCTCCAGGGTCCTAAATCTGAGGTAGCACGGCACGGCACAAGATGGTACCCA
TGGTGCGTGACGACAGCCGCTACTTGCACGGCTTTGTTCCGGCAGCCCGGGTACCCGCGC
TGCGAGTTGAAACATCATCAAACCAAAAGGGAAGCGACGTTAGTTTTTTTCATTGCGCTA
GCTATGACGTTTGGGTGGCCTAGCCGGTTCGCGTGTGCCTGTCGCTTTTGTCGCTTTTCA
ACTTCTGCCCGATATTTCCTATCAAAGGAAAATGGGACGTTTTCAACCCCTCGCTATCAT
CGTGCCTGCACTCTGCCTATCGCCAACTACACCGGGGTTTTATCTGCTTCACCCCTCCAT
CCAGTGCTGATAACAAGAAGAACCTTGCAGGGTAGGGCAGGACCTACGGCCAAAATACTA
ATTATGTCTGTTTATGTACATGCCCCAATCTGAATATTCCATGAATGTAGGCACAGCATA
TCTCCATCCATGTACTGATACAGACGCATAAACATATATGTATATACATACTTATACACT
CGAATATTTGTAGACTGATGTACTTCTATATATATATAGGGGGTTTGTGTTCCTCTTCCT
TTCCTTTTTTTTTCTCTCTTCCCTTCCAGTTTCTTTTATTCTTTGCTGTTTCGAAGAATC
ACACCATCAATGAATAAATC
>MEP3   MEP3; upstream from -800 to -1; size: 800; feature type:gene; location: Saccharomyces_cerevisiae:NC_001148.3:812450:813249:R
GCGACAAATATAAACTAGTCTCACGGAAGTTAGATGTTGAATCTAAGAGGAATTTTGTGA
AGGAATATATCAGCGATCAACGTAAAAAGAGGAAGTAGAAATACTTATGAAGGCATGCAT
GCATGCATACATATTTATATATATATGTCTTTAGGAGTATGTATTGCATTTAATCGAAAC
AAACAAGAAAAAGAAGAGTAGATGTGCCCGTTTCTGTCACTCCTATTTACTGACACTTTC
TTGACCTACCTCAAACCAGTTCCAGTTCCGGCAAAAAGTGCCGCGCGGCGGAGAAACATC
TCCACCTTATCTCGGCGCCAAATCCTTATCTCTCGTAGCTGGTTTGCCCGCGATAAGGCG
GGCGAGTTATTTTGAAGTTTTCCATAAACTGGTTTTCCATCTCGAGGTTTTTCCTCGCTT
TCCACGCTATGACCCTTTTTAGTTAAGGTACCCGATGGCATACTTTATATATTATATATA
TATGTTAAGTTAATATGTTTTAGCAGATTTGATATGCTGATATGCAGCACGGACTTTCCC
TCTCCTTGTCTTATCGCATCTTATCGCAACAATTTGATAGATATCTTCTCCCTTTCCTAT
CTTGTAGAATAAGGTTGTGTGCTTTGAGTCTGATAGCCGTCTTCTTTCGGTCGCTTCTTC
TCTCTTTTGGTTCTTTGATTGTCTATTACAATCAATGCAGGCTAGTTAAGGGTCCAATCA
CTTTTGAAATTGTTTTGTAAAAAGCGAAGGCATTTTTTTTTTAGAAGATACAATTGAAAA
CATATAGATTTAGAGTTCAC
>DAL80  DAL80; upstream from -800 to -1; size: 800; feature type:gene; location: Saccharomyces_cerevisiae:NC_001143.7:505740:506539:D
GTTCATTAGAGTGCATAATATGGTCTAATGAGTGGTTCGGTGACACATCACTCAGGTTTC
TATCTACAAAGGATTTGGGCAATGCATGCTTCCTCTCCGCCTCCTTGCCGTTGGGAGTTC
TTCGTTTTTCTCTTTGTAAACTGCTAGTCAGATTGCCATTCTCAGGTAATTGCCGCAATA
CTTCTTGGTTTTCTAACTCATCTGGTCTCGAATTTACTCTATCTACTTCTTCAGTCACCG
ATCTATCTGCCTGAGGTGGAGCGAAGTGAGTTCCAGACGCTGTTGACACGTTAGACATCA
CCCTTGTTTATCTATCCTACCTTTTCTTCTTGCGTACGTGCCTCTCAATGCGTCGTGTGA
ATTATCAGTGACCGGTCGTGCCTATAATGTCCTGCTAATTTCCCACTAAATCTTTCCCCA
TGGCGTATTCATCGTTATGTTTGTGTCTTTTGTTCAACCCAAAGGGCTGTAGCAATCTTC
ACCCGTTTGTCGTTGATAACGAGTTTCCACCTTATCACTTATCACTAGTGCTAATCAAAC
AGCAAAGAATGCTTGATAGAAACCGATCCTGGGCTTATCTCGCTGCATTGTGGCGGCATC
CCTGGACTGTAATCAGCAAGTGTTGCTTAGTATATATATACATCCAGCGTCAGCTTGAAT
TTGGATACAGTTACTGTTTTTTCGATTTTCTCTTGGTTATTCTTTCTGAGACAGTAGTAA
TTTTGTATTACTGAGCGGGATATTGTTTATCTGCCGTCATACTATATTACATTATATTAT
ATCATATTATATATAAGAGA
```

 

********************************************************************************

## Running a docker on the command line



```
mkdir -p ~/Docker

docker run -t -i -m 1g  \
	-v  ~/Docker:/DockerIn \
	-v ~/Docker:/DockerOut \
	-v ~/Docker:/DockerTodo \
	rsat_debian:2016-07-13 /no_backup/RSAT_Docker/DockerTodo.sh \
	> ~/Docker/output.txt
```

