#!/usr/bin/env perl
# the first line of the script must tell us which language interpreter to use,
# in this case its perl

use strict;

# import the modules we need for this test; XML::Compile is included on the server
# by default.
use XML::Compile::SOAP11;
use XML::Compile::WSDL11;
use XML::Compile::Transport::SOAPHTTP;
use Data::Dumper;

eval
{
    # Retriving and processing the WSDL
#    my $wsdl  = XML::LibXML->new->parse_file('http://rsat.ulb.ac.be/rsat/web_services/RSATWS.wsdl');
    my $wsdl  = XML::LibXML->new->parse_file('http://pedagogix-tagc.univ-mrs.fr/rsat/web_services/RSATWS.wsdl');
    my $proxy = XML::Compile::WSDL11->new($wsdl);
    
    # Generating a request message based on the WSDL
    my $client = $proxy->compileClient('peak_motifs');
    
    #Defining a few parameters
    my $sequence = '>mm9_chr3_121848111_121848740_+
tggggtgggttccaggacagccaggactgtcacacaaagaaaccttgtctcaaaaaaaca
aaaCAAAAAACAAAACAAAACCAAGCAAGCAAGCAAACATGGGCTTAAATctggatacag
tggcctttatttctagttccagtgactgggagactgaaacaagagagtcacttgagtaca
ggagtgcaaggctagcttgagcaatatagtaagactatctcaaaaTGTGAATTtagatca
acagaattgacatcaagaaaaatactgatatcactcaaagcaatctacagattcaacaca
atctccatcaacatgacaatgacttccatcaGCATGACAATGACTCCATCAACATGCCAA
TGGGCCCCATCAACATAACAATGACCCCTATCATCATGACAATGATCCCCATCAACATGA
CAATGACCTCCATCAACATGACAATTACTCCTGTCAACATGCCAATtgttggggttcaga
agtcaccctgcaaaccacaagaacactaatctcagtcaagcagggatggtttactgaacg
tatatccaaagactgagtgaccaagggaacagctcagactctagagctgaaagctagctg
tgcgctggacatttctcggggccaactta
>mm9_chr14_86795691_86796311_+
CTCAAGGAGGATCCAGAAGTTGGCAGTTTCTGAGGCGAGTCCCATATTCCTCCCCTAAGG
GGTCAGGATTTTTCAGGTCTGGGCTCTTCTTGTTCTTTTGACAGCGACATTAATAATTGT
ACCAGCTCTCCCCTGGCAGGGCCGCACCACAGAGTAAAGCCTGGAGTAGGAGCTGTGCCC
AGCGCAATAATACCAGTTAAATAAGTACGTTCATTACCTCCCAACAGTCAAGGAGTTTAA
AATCCGTCAATTCACCCCACATGAGGGAGATTATGTGATTTACATGTTAAAGTGCCCCTG
TGGTTTGATTTGCATAGCAAAGACTTTGGGGGCACAGAAACAAAGCATCCGCATGCATGA
CAAGAGGACTATTAGCATAGAGAGAGCAGGTTTTCCGACAGCCCAGCCTGGCAAACAATG
CTGCACCTTCGCTGCTCGCTGGAGTTTATAGGATTTGACAGTTTCTCATCTGAGGGAGGA
GAAGGTTAGGGAGTTGGGGTGGAATGAGGTTCGCTAGATTGGCTGTCTGCCTTAAGCACA
ATAATTTGTCTTTCTCTGAAGACCTCCCCTCCTCTTATCACCTTTATCGTTTCTTTCTGA
TGTTCATTCAAAGACGTCTT
>mm9_chr15_84452311_84453000_+
CACGTTCTTCCTCAGGTGCAGGTCAGCCCAGCTTCCTTTTACAGCTCTGAACCACCACCG
TTGTCACTGTGCCTGTGAGTCACCGATGCAGGTGCCCTGACCTTTGTATGTTTGTACCTC
ATCTCCAGCTAGGTTCTCATCATGGGGCCCCATGAACCCCAAATCCCACAGAGCAGACAA
ACTTCCCTTCTACCTTATGGCTTAAGCAGGACAGTCAATAGCCGGCTTTCTTCCAATGCT
TTCCAACTGTTTCTAACCAGCCAGAAGTGTCCTCCTGCTGTGAGCCGGGACCACCTGCCA
GGCAGAATGAATATGCATATATGCTAATCAGAGTAGCCTAAGATTTGCATGACAATCGGA
GGCCAATTCTCCCACTCAGGAGTGGCTTCCAAAGGCAGCTCAGATCTGCTTTGGAGGCTG
CCTGGGGAGGTGGGGTGGGACTCTGCAACCCAGGGCTCTGGGTGACCTGGCCCTCGCGGA
CCTTGAATTTTCAAACAGACTCAGGAGCCTAGAAGACCAGGTTGAGGCAACTATGAGATG
CCAGTCTGTCTATCCCTGTAACTGCCCCTCAAGGGAAACGGGGACAGAGAGGTTGCTTCC
CTGTGGAGGCTCAGGGAGGAGCAATCTGGGGACGGCCCTCCCAGGAGCTTCCAAAAGGGA
AATTACCCGGCTGTGGCCAGGTCTCTTAA
>mm9_chr1_134118761_134119120_+
GATTGGCAATTAAACCTGCCTCAAGAATGGGGTGGAAATGCCTTCTCGGCTATGGGGAGA
ATAGAAACAAAACCAAGCCAAAGCCCAGAACCACACAGATAAGACTGACAGAAAGGCTGT
GCACACTGATGCCAAATATTCAGGATTTCACCCAGGAATCCTCCCATGGAACAATGCTGA
CAATGGCTCCATGCATATGCATGAGGGGAGCTCGGAGGAGAGGAGAGCTTCAGATGCCAC
GGTCTGTCTGAAGGCAGAGGAGGAAGCTCAACCCACATGTGCTGGGGAAGGCGTGCCCGT
TGATCTTTTTTGTAACCCCACTGGTTTCAAATTCCAGGAGTTTGATCAAGAAaaacaaa';

    my %args = (
#	'verbosity' => 1,
#	'output' => 'client',
	'test' => $sequence, 
	'motif_db' => 'cisBP_mouse'
	);

    # Calling the service and getting the response
    my $answer = $client->( request => {%args});

    if ( defined $answer ) {
      warn ("Server command : ".$answer->{output}->{response}->{command}."\n");
      if ($answer->{output}->{response}->{server}){
	print "\nResult :\n\n", $answer->{output}->{response}->{server}, "\n";
	exit 0;
      } else {
	  print "$answer->{Fault}->{faultstring}\n";
      }
    }
};

if ($@)
{
    print "Caught an exception\n";
    print $@."\n";
    exit 1;
}
