################################################################
##
## Generate figure to compare patser top scores between 
## the different matrices 
##

## source('~/research/discriminant_analysis/met_pho/R-files/fig_patser_top_scores_dotplots.R')

## files and directories
setwd('~/research/R-files')
source('config.R')
setwd(dir.util)
source('palette.R')
source('util.R')
source('util_mva.R')
source('util_sda.R')
source('chip_normalisation.R')

dir.main <- paste(dir.home, 'research/discriminant_analysis/met_pho', sep='/')
dir.results <- paste(dir.main, 'results', sep='/')
dir.figures <- paste(dir.results, 'figures', sep='/')

## data type
data.type <- "matrix_scores"

## load the data
setwd(paste(dir.main,'R-files',sep='/'))
source("load_met_pho_data.R")



draw.figure <- function (...) {
  attach(training)
  
  par(mai=c(0.6,0.6,0.1,0.1))
  par(cex.lab=1.5)
  par(font.lab=2)
  par(font=2)
  par(mfrow=c(2,3))
  
  plot(Pho4p.1, Met31p.1,
       xlab="Pho4p", 
       ylab="Met31p",
       panel.first=grid(col=1),
       ...
       )
  ##  legend(max(Pho4p.1),max(Met31p.1),names(group.palette), col=group.palette,pch=19,cex=0.8)

  plot(Pho4p.1, Met4p.1,
       xlab="Pho4p", 
       ylab="Met4p",
       panel.first=grid(col=1),
       ...
       )
  ## legend(min(Pho4p.1),max(Met4p.1),c("PHO","MET","CTL"), col=group.palette,pch=19,cex=0.8)

#   plot(Pho4p.t.1, Met4p.1,
#        xlab="Pho4p.t", 
#        ylab="Met4p",
#        panel.first=grid(col=1),
#        ...
#        )
#   ## legend(min(Pho4p.t.1),max(Met4p.1),c("PHO","MET","CTL"), col=group.palette,pch=19,cex=0.8)

#   plot(Pho4p.g.1, Met4p.1,
#        xlab="Pho4p.g", 
#        ylab="Met4p",
#        panel.first=grid(col=1),
#        ...
#        )
#   ## legend(min(Pho4p.g.1),max(Met4p.1),c("PHO","MET","CTL"), col=group.palette,pch=19,cex=0.8)

#   plot(Pho4p.g.1, Pho4p.t.1,
#        xlab="Pho4p.g", 
#        ylab="Pho4p.t",
#        panel.first=grid(col=1),
#        ...
#        )
#   ## legend(min(Pho4p.g.1),max(Pho4p.t.1),c("PHO","MET","CTL"), col=group.palette,pch=19,cex=0.8)

  plot(Met4p.1, Met31p.1,
       xlab="Met4p", 
       ylab="Met31p",
       panel.first=grid(col=1),
       ...
       )
  ## legend(min(Met4p.1),max(Met31p.1), c("PHO","MET","CTL"), col=group.palette,pch=19,cex=0.8)

  plot(Pho4p.1, Pho4p.2,
       xlab="Pho4p - first score", 
       ylab="Pho4p - second score",
       panel.first=grid(col=1),
       ...
       )
  ## legend(min(Pho4p.1),max(Pho4p.2),c("PHO","MET","CTL"), col=group.palette,pch=19,cex=0.8)

  plot(Met4p.1, Met4p.2,
       xlab="Met4p - first score", 
       ylab="Met4p - second score",
       panel.first=grid(col=1),
       ...
       )
  ## legend(min(Met4p.1),max(Met4p.2),c("PHO","MET","CTL"), col=group.palette,pch=19,cex=0.8)

  plot(Met31p.1, Met31p.2,
       xlab="Met31p - first score", 
       ylab="Met31p - second score",
       panel.first=grid(col=1),
       ...
       )
  ## legend(min(Met31p.1),max(Met31p.2),c("PHO","MET","CTL"), col=group.palette,pch=19,cex=0.8)

  par(mfrow=c(1,1))
  detach(training)
}

#palette <- c('#BBBBBB','#888888','#000000')
palette <- c('#888888','#ff0088','#008800')

training <- data[!is.na(group.labels),]
group.palette <- get.palette(data,group.labels)
colors.all <- get.colors(data,group.labels)
colors.training <- colors.all[row.names(training)]
pch.training <- substr(group.labels[row.names(training)],1,1)


draw.figure(
            col=colors.training, 
            pch=pch.training, 
            xlim=c(0,15),ylim=c(0,15)
            )


setwd(dir.figures); export.plot(file.prefix="met_pho_expression_selected_var_pairs", export.formats= c("pdf", "ps"), width=10.5,height=7,horizontal=T)

