################################################################
## Function definition for the analysis of 
## methioine/phosphate genes 
##

################################################################
## Clustering
test.clustering <- function() {
  setwd(dir.figures)
  dist.metric <- "euclidian"
  clustering.method <- "complete"
  par(cex=0.7)
  for (dist.metric in c("manhattan", "euclidian")) {
    for (clustering.method in c("average","ward", "complete")) {
      d <- dist(training.data,method=dist.metric)
      h <- hclust(d, method=clustering.method)
      file.name <- paste (data.type,"hclust", dist.metric, clustering.method, sep="_")
      plot(h,labels=training.full.labels, main=paste(data.title, dist.metric, clustering.method, sep = ' - '))
      export.plot(file.prefix=file.name, export.formats=export.formats.plots,width=18,height=5)
      print (table(cutree(h,k=3),training.labels))
      print (table(cutree(h,k=4),training.labels))
    }
  }
  par(cex=1)
}

################################################################
## Flexible Discriminant Analysis
test.fda <- function () {
  y = cbind(training.data, group.labels=training.labels)
  mfda <- fda(group.labels ~.,data=y)

  ## export the FDA plot
  plot(mfda)
  setwd(dir.figures)
  file.name <- paste(data.type, "FDA", sep="_")
  export.plot(file.prefix=file.name, export.formats=export.formats.plots,width=8,height=8)

  confusion(mfda)

  mfda
  names(mfda)
  coef(mfda)

  attach(mfda)
  percent.explained
  means			
  values			
  values/(1-values)	# eigenvalues
  prior
  fit
  
  if (length(groups) == 2) {
    hist(fit$fitted.values,breaks=30)
  } else if (length(groups) == 3) {
    plot(fit$fitted.values,type="n")
    text(fit$fitted.values,training.labels)
  }
  
#    result <- data.frame(true = group.labels,
#  		       predict = predict(mfda),
#  		       fitted.value = fit$fitted.value,
#  		       post = predict(mfda,type="post"),
#  		       variates = predict(mfda,type="variates"),
#  		       row.names = names(group.labels))
#    result
#    result[result$predict != result$group.labels,]
  
  detach(mfda)

  ## predict class for all genes with FDA
  y.all <- cbind(data,group.labels)
  prior <- c("CTL"=0.98, "PHO"=0.01, "MET"=0.01)

  pred.all.class <- predict.fda(mfda,y.all, prior=prior,type="class")
  table(pred.all.class) 
  confusion(pred.all.class,group.labels)


  setwd(dir.results)

  pred.all.post <- predict.fda(mfda,y.all, prior=prior, type="posterior")
  pred.all.vars <- predict.fda(mfda,y.all, prior=prior, type="variates")
  fda.result <- data.frame("trainig.class" = group.labels,
			   "class"=pred.all.class,
			   "post"=pred.all.post,
			   "var"=pred.all.vars)
  export.object(fda.result, file="FDA_predictions",export.formats="table")

  plot(fda.result$var.1, fda.result$var.2, type="n")
  text(fda.result$var.1, fda.result$var.2, pred.all.class)
}


################################################################
#### compare PHO predictions with gene expression data
compare.expression <- function () {
  ## first select the ORF name which are found in both data sets  
  orf.names.exp <- row.names(pho)
  orf.names.common <- intersect(row.names(data),orf.names.exp)

  expr.max <- apply(expr,1,max,na.rm=T)
  expr.min <- apply(expr,1,min,na.rm=T)
  expr.top <- apply(abs(expr),1,min,na.rm=T)
  expr.mean <- apply(expr,1,mean,na.rm=T)
  expr.median <- apply(expr,1,median,na.rm=T)
  plot(data.frame(expr.top,expr.mean,expr.median))

  plot(pred.all.post[orf.names.common,"PHO"],expr.top[orf.names.common])
  plot(pred.all.post[orf.names.common,"PHO"],expr.mean[orf.names.common])
  plot(pred.all.post[orf.names.common,"PHO"],expr.median[orf.names.common])
}
