################################################################
## General configuration for the MET-PHO classification

print ("Loading libraries")
source('~/research/R-files/config.R')
setwd(dir.util)
source('util.R')
source('util_mva.R')
source('util_sda.R')
source('util_chip_standardization.R')

verbose("Initializing parameters", 0)

# data.type <- "expression"
data.type <- "matrix_scores"
# data.type <- "oligo_counts"

#discrim.group <- "3groups"
discrim.group <- "PHO"

do.pc <- T ### The results are never better, and it adds confusion for the article
test.number <- 100 ## Number of permutation tests

dir.main <- paste(dir.home, 'research/discriminant_analysis/met_pho', sep='/')
dir.results <- paste(dir.main, 'results/discrim_results', sep='/')
dir.figures <- paste(dir.results, 'figures', sep='/')

dir.create.check(dir.results)
dir.create.check(dir.figures)

source(file.path(dir.main, "R-files","predict_best_pda.R"))
source(file.path(dir.main, "R-files", "functions_met_pho.R"))

prior.all.3groups=c(CTL=0.98,MET=0.01,PHO=0.01)
prior.all.MET=c(CTL=0.99,MET=0.01)
prior.all.PHO=c(CTL=0.99,PHO=0.01)


################################################################
## Prior probabilities for variable selection
##prior.selection <- prior.all
prior.selection <- NA

## ##############################################################
## primary name and description for yeast genes
#feature.file <- file.path(dir.home,"rsa-tools","data","genomes","Saccharomyces_cerevisiae','genome','feature.tab")
#feature.file <- file.path(dir.home,"research","seq_analysis","yeast","Feature_Saccharomyces_cerevisiae.tab")
feature.file <- file.path(dir.main,'data',"Feature_Saccharomyces_cerevisiae.tab")

x.desc <- read.table(feature.file,header=T,row.names=1,sep="\t",as.is=T,fill=T)
row.names(x.desc) <- toupper(row.names(x.desc))

verbosity <- 1
export.formats.obj <- c("print")
export.formats.plots <- c("pdf", "ps")
