################################################################
## select the optimal linear discriminant function
## and analyse confusion
predict.best.pda <- function(pda.eval,group.labels,data, data.prefix) {
  
  ## select the best variables
  ## use.pc <- F
  for (use.pc in c(F,T) ) {
    if ((do.pc) & (use.pc)) {
      pc.prefix <- 'PC'
      step.pda <- pda.eval$pc.stepwise.lda
      best.pda<- step.pda$best.pda
      best.vars <- step.pda$best.vars
      best.var.names <- step.pda$best.var.names
      data.pc <- princomp.with.group.labels(data, group.labels,display.plot=F)
      ##    best.data <- (data)$scores[,best.vars]
      best.data <- data.pc$scores[,best.vars]
    } else {
      pc.prefix <- 'noPC'
      step.pda <- pda.eval$stepwise.lda
      best.pda<- step.pda$best.pda
      best.vars <- step.pda$best.vars
      best.var.names <- step.pda$best.var.names
      best.data <- data[,best.vars]
    }
    
    ## plot objects on the PCA axes, to compare prior and assigned classes
    ##      verbose ("Plotting objects on LD axes", 1)
    ##      plot.pda.calib(best.data, group.labels, pda.method="lda", loo=T, main=paste(data.prefix,'Cross-validation (LOO)'))
    ##      setwd(dir.figures); export.plot(file.prefix=paste(data.prefix, pc.prefix, "cross_validation_LOO", sep="_"), export.formats=export.formats.plots)
    ##      setwd(dir.results); export.object(best.pda, file=paste(data.prefix, pc.prefix, "best_pda_LOO", sep="_"),export.formats=export.formats.obj)
    ##      setwd(dir.results); export.object(best.pda$confusion, file=paste(data.prefix, pc.prefix, "best_pda_LOO_confusion", sep="_"),export.formats=export.formats.obj)
    
    ## plot misclassified units with LOO
    verbose ("Plotting misclassified objects", 1)
    misclass.loo <- plot.misclassified.units(data,group.labels,best.pda, data.title=paste(data.title, "LOO"),display.plot=T)
    setwd(dir.figures); export.plot(file.prefix=paste(data.prefix, pc.prefix, "misclassified_profiles_LOO", sep="_"), export.formats=export.formats.plots,width=9,height=5)
    
    ## predict class for the whole data set
    verbose ("Predictive LDA", 1)
    pred.lda <- pda(best.data,group.labels,loo=F,pda.method="lda", prior=prior.all) ### predictive LDA
    predictions.matrix.scores <- cbind(group.labels,as.data.frame(predict(pred.lda,best.data,prior=prior.all)))
    predictions.matrix.scores <- cbind(predictions.matrix.scores,x.desc[row.names(predictions.matrix.scores),c("NAME","DESCR")]) ### add gene name and description
    predictions.matrix.scores <- predictions.matrix.scores[order(predictions.matrix.scores[,"posterior.CTL"]),] ## order according to posterior probability<
    setwd(dir.results); export.object(predictions.matrix.scores, file=paste(data.prefix, pc.prefix, "stepwise_LDA_pred", sep="_"),export.formats="table")
                                        #      setwd(dir.results); write.table(predictions.matrix.scores, file=paste(data.prefix, pc.prefix, "stepwise_LDA_pred.tab", sep="_"),sep="\t", row.names=F,quote=F)
    
    if ((do.pc) & (use.pc)) {
      predictions.matrix.scores.PC <- predictions.matrix.scores
    } else {
      predictions.matrix.scores.noPC <- predictions.matrix.scores
    }
    
    ## count objects per predicted class
    verbose ("Counting objects per predicted class", 1)
    (pred.counts <- table(predictions.matrix.scores$class))
    setwd(dir.results); export.object(pred.counts, file=paste(data.prefix, pc.prefix, "stepwise_LDA_pred_counts", sep="_"),export.formats="print")
    
    ## confusion table with the predictive function
    (pred.conf <- confusion(predictions.matrix.scores$class,predictions.matrix.scores$group.labels))
    setwd(dir.results); export.object(pred.conf, file=paste(data.prefix, pc.prefix, "stepwise_LDA_pred_confusion_internal", sep="_"),export.formats="print")
    
    ## plot profiles of misclassified units
    verbose ("Misclassified objects with predictive discriminant function", 1)
    misclass <- plot.misclassified.units(data,group.labels,pred.lda, data.title=paste(data.title, "internal"),display.plot=T)
    setwd(dir.figures); export.plot(file.prefix=paste(data.prefix, pc.prefix, "misclassified_profiles_internal", sep="_"), export.formats=export.formats.plots,width=9,height=5)
    
    ## plot all objects on the two first LD axes, with coloring and letters
    if (length(groups) >= 3) {
      verbose ("LD1-LD2 plot", 1)
      par(mai=c(0.7,0.7,0.7,0.1))
      par(font=2)
      par(cex=0.7)
      plot(predictions.matrix.scores$x.LD1,
           predictions.matrix.scores$x.LD2,
           pch=substr(as.vector(predictions.matrix.scores$class),1,1),
           col=get.colors(data,group.labels),main=)
      setwd(dir.figures); export.plot(file.prefix=paste(data.prefix, pc.prefix, "prediction_LD_plot", sep="_"), export.formats=export.formats.plots,width=9,height=8)
    }
  }
}
