## ##############################################################
## After having predicted gene class with the annotated genes, use the
## predicted genes to build a new discriminant function, and redo the
## evaluation.
## source("~/research/discriminant_analysis/met_pho/R-files/second_round_prediction.R")

source("~/research/discriminant_analysis/met_pho/R-files/met_pho_config.R")


discrim.group <- "MET"

## test 3-group and 2-group classifications
for (discrim.group in c("PHO", "MET",  "3groups")) {
# for (discrim.group in c("MET")) {
  
  verbose(paste("Data type", data.type), 1)
  verbose(paste("Discrimination group", discrim.group), 1)
  
  ## ##############################################################
  ## load the data
  setwd(paste(dir.main,'R-files',sep='/'))
  source("load_met_pho_data.R")

  ## select the group labels
  group.labels <- get(paste("group.labels", discrim.group,sep="."))  
  data.prefix <- paste(data.type, discrim.group, sep="_")
  data.title <- data.prefix
  groups <- names(table(group.labels))
  prior.all <- get(paste("prior.all", discrim.group,sep="."))  
  prior.training <- table(group.labels)/sum(table(group.labels))

  ## directories
  dir.results <- paste(dir.main, 'results/discrim_results', data.prefix, sep='/')
  dir.figures <- paste(dir.results, 'figures', sep='/')
  dir.create.check(dir.results)
  dir.create.check(dir.figures)

  ## Load the previous predictions
  file.predictions <- file.path(dir.results, paste(paste(data.prefix, "noPC", "stepwise_LDA_pred", sep="_"), ".tab", sep=""))
  predictions <- read.table(file.predictions, sep="\t", as.is=T, header=T,row.names=1)
  group.labels.expanded <- group.labels
  group.labels.expanded[row.names(predictions[predictions$class != "CTL",])] <- predictions[predictions$class != "CTL","class"]
  print(table(group.labels.expanded))

  ## Evaluate discriminant analysis with the different methods
  pda.eval.expanded <- compare.stepwise.pda.methods(data,group.labels.expanded,data.title=paste(data.title, "expanded", sep="_"),qda=T,with.pc=T,max.p=max.p, prior=prior.selection,test.number=test.number)

  setwd(dir.figures); export.plot(file.prefix=paste(data.prefix, "expanded", "stepwise_PDA_error_profiles", sep="_"), export.formats=export.formats.plots, width=10,height=7)
  setwd(dir.results); export.object(pda.eval.expanded, file=paste(data.prefix, "expanded", "stepwise_PDA", sep="_"),export.formats=export.formats.obj)
  setwd(dir.results); export.object(pda.eval.expanded$errors, file=paste(data.prefix, "expanded", "stepwise_PDA", "error_profiles", sep="_"),export.formats="table")


# Bricolage
#    pda.eval.expanded <- list(); setwd(dir.results);
#    pda.eval.expanded$errors <- read.table(paste(data.prefix, "_expanded", "_stepwise_PDA", "_error_profiles", ".tab", sep=""), header=1,row.names=1,sep="\t")
  
  ## figures for the article
  plot.error.profiles(pda.eval.expanded$errors, main="", plot.legend=F)
  setwd(dir.figures); export.plot(file.prefix=paste(data.prefix, "expanded",  "stepwise_PDA_error_profiles", "nolegend", sep="_"), export.formats=export.formats.plots, width=7,height=5)
  
  ## monochrome figures for the article
  plot.error.profiles(pda.eval.expanded$errors,
                        main="",
                        plot.legend=F,
                        col=c("#000000", "#333333", "#000000", "#333333",
                          "#666666","#999999","#666666","#999999"))

  setwd(dir.figures); export.plot(file.prefix=paste(data.prefix, "expanded",  "stepwise_PDA_error_profiles", "nolegend", "bw", sep="_"), export.formats=export.formats.plots, width=7,height=5)
  
  ## Second round predictions
  predict.best.pda(pda.eval.expanded, group.labels.expanded, data, data.prefix=paste(data.prefix, "expanded", sep="_"))
  
}
