degseq <- function(net){
	redundant = TRUE
	bait <- as.character(net[,1]); prey <- as.character(net[,2])
	proa <- c(); prob <- c()
	samples <- length(bait)
	self <- 0; repeats <- 0; total <- 0
	if(length(bait) != length(prey)){
		warning("The two collections are of different lengths.")
		return(0)
		}
	for(i in 1:samples){
		if((prey[i]) == (bait[i])){self <- self + 1}
		else{
			if(prey[i] > bait[i]){proa <- c(proa,prey[i]); prob <- c(prob,bait[i])}
			else{proa <- c(proa,bait[i]); prob <- c(prob,prey[i])}
			}
		}
	
	if(self == samples){
		return(degree=c(0), repeats=0, self=self, samples=samples)
		}
	
	if(redundant== TRUE){
		repeatlist <- c()
		sortedseq <- order(proa,prob)
		proa <- proa[sortedseq]; prob <- prob[sortedseq]
		total <- samples - self
		if(total >= 2){
			for(i in 2:total){
				if(proa[i-1] == proa[i] & prob[i-1] == prob[i]){
					repeatlist <- c(repeatlist,i)
					}
				}
			repeats <- length(repeatlist)
			if(repeats > 0){
				proa <- proa[-repeatlist]; prob <- prob[-repeatlist]
				}
			#else{
				#warning("There are no repeats in network data, so capture-recapture methods are not applicable.")
			#	}
			}
		}
		
	degtable <- table(c(proa,prob))
	nodes <- unique(degtable)
	maxdeg <- max(nodes)	
	degree <- c()
	for(i in 1:maxdeg){
		degree <- c(degree,length(degtable[degtable == i]))
		}
	
	indegtable <- table(proa)
	innodes <- unique(indegtable)
	inmaxdeg <- max(innodes)
	indegree <- c()
	for(i in 1:inmaxdeg){
		indegree <- c(indegree, length(indegtable[indegtable == i]))
		}

	outdegtable <- table(prob)
	outnodes <- unique(outdegtable)
	outmaxdeg <- max(outnodes)
	outdegree <- c()
	for(i in 1:outmaxdeg){
		outdegree <- c(outdegree, length(outdegtable[outdegtable == i]))
		}

	#return(list(degree=degree,repeats=repeats,self=self,samples=samples))
	return(list(degree=degree,indegree=indegree,outdegree=outdegree, samples=samples, repeats=repeats, self=self))
}