plot.modelfreq <- function(net,netlike=NULL,nodethick=0.4,title="Expected Frequency-Degree Plots for MLE Models",textsize=0.6, ...){
	netdeg <- degseq(net)
	if(is.null(netlike)){netlike<-mmi.likelihoods(net)}
	#if(is.null(netakaike)){netakaike<-mmi.akaike(netlike,mmi=TRUE)}
	
	maxpdeg <- sum(netdeg$degree)-1; maxdeg <- length(netdeg$degree); nodes <- maxpdeg + 1
	thick <- nodethick
	if(maxpdeg > 1000){
		maxplot <- maxpdeg/5
	}else{maxplot <- maxpdeg}
	plot(seq(1,length(netdeg$degree))[netdeg$degree > 0],netdeg$degree[netdeg$degree > 0],log="xy",yaxt="n",xaxt="n",ylab="Node Frequency (observed or expected)", xlab="Node Degree",main=title,cex=thick,pch=16,xlim=c(1,maxplot), ...)
	axis(2,format(10^(seq(from=0,to=log(maxpdeg/10),by=1)),scientific=FALSE))
	axis(1,format(10^(seq(from=0,to=log(maxplot),by=1)),scientific=FALSE))
	
	#axis(2,10^(seq(from=0,to=log(maxpdeg/10),by=1)))
	#axis(1,10^(seq(from=0,to=log(maxplot),by=1)))
	edges <- netdeg$samples - netdeg$self - netdeg$repeats

    colors <- c("green","blue","red","purple","cyan","black")

	val <- netlike$poisson$param
	norm <- sum(drandom(seq(1:maxpdeg),val))
	density <- drandom(seq(1:maxpdeg),val)/norm
	name <- "Poisson"
	lines(seq(1,length(density),by=1),nodes*density,col=colors[1])

	val <- netlike$exponential$param
	norm <- sum(dexpnetz(seq(1:maxpdeg),val))
	density <- dexpnetz(seq(1:maxpdeg),val)/norm
	name <- "Exponential"
	lines(seq(1,length(density),by=1),nodes*density,col=colors[2])

	val <- netlike$powerlaw$param; norm <- sum(dpowerlaw(seq(1:maxpdeg),val)); density <- dpowerlaw(seq(1:maxpdeg),val)/norm; name <- "Power Law"
	lines(seq(1,length(density),by=1),nodes*density,col=colors[3])
	
	val <- netlike$lognormal$param; norm <- sum(dlognormal(seq(1:maxpdeg),val)); density <- dlognormal(seq(1:maxpdeg),val)/norm; name <- "Log Normal"
	lines(seq(1,length(density),by=1),nodes*density,col=colors[4])

	val <- netlike$stretchedexp$param; norm <- sum(dstretchedexp(seq(1:maxpdeg),val)); density <- dstretchedexp(seq(1:maxpdeg),val)/norm; name <- "Stretched Exponential"
	lines(seq(1,length(density),by=1),nodes*density,col=colors[5])

    models <- c("Poisson", "Exponential", "Power Law", "Log Normal", "Stretched Exponential","Observed Network")
    legend("topright", legend=models, col=colors, pch=c(rep(15,5),16),cex=textsize,inset=0.02)
	}