\name{mmi.akaike}
\alias{mmi.akaike}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Find the Akaike Weights and Model Averaged Degree Distribution}
\description{
This function takes a net (as an edge list), or a degree list (as a vector where entry \code{i} details the number of nodes with degree \code{i}), and performs likelihood analysis as found in \code{\link{mmi.likelihoods}}. The output consists the of Akaike weights that relate to the likelihood analysis, and the probability distribution for the degrees in the network using the Akaike weights and the standard probability models described in \code{\link{distributions}}.}
\usage{
mmi.akaike(net,parrand=c(0.1,100),parexp=c(0.01,1),parpow=c(1.01,10),parlnorm=c(1,1),parstrexp=c(1,1),nodes=1,degree=FALSE,mmi=FALSE,IC="AIC")
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{net}{ an edge list for a network or when \code{degree = TRUE} a degree list. Alternatively this can be the output from \code{\link{mmi.likelihoods}} if \code{mmi = TRUE}.}
  \item{parrand}{ vector describing the \code{min} and \code{max} for the \code{\link{drandom}} distribution parameter, over which the likelihood is assessed.}
  \item{parexp}{ vector describing the \code{min} and \code{max} for the \code{\link{dexpnetz}} distribution parameter.}
  \item{parpow}{ vector describing the \code{min} and \code{max} for the \code{\link{dpowerlaw}} distribution parameter.}
  \item{parlnorm}{ vector describing the starting parameter values for the \code{\link{dlognormal}} distribution parameter, from where the optimisation is seeded.}
  \item{parstrexp}{ vector describing the starting parameter values for the \code{\link{dstretchedexp}} distribution parameter, from where the optimisation is seeded.}
  \item{nodes}{ the complete number of nodes found in the network, if data is viewed as a subsample of the complete network, using \code{\link{subsample}}. This is only necessary if the parameter values, as opposed to the maximum likelihoods, are sought for each function.}
  \item{degree}{ detailing whether \code{net} is a degree sequence.}
  \item{mmi}{ details wheterh \code{net} is the output for a network from \code{\link{mmi.likelihoods}}.}
  \item{IC}{ string detailing which information criterion should be used, either \code{AIC} or \code{BIC}.}
}
\value{
A list with components:
  \item{random}{ Akaike weight for the \code{\link{drandom}} degree distribution.}
  \item{exponential}{ Akaike weight for the \code{\link{dexpnetz}} degree distribution.}
  \item{powerlaw}{ Akaike weight for the \code{\link{dpowerlaw}} degree distribution.}
  \item{lognormal}{ Akaike weight for the \code{\link{dlognormal}} degree distribution.}
  \item{stretchedexp}{ Akaike weight for the \code{\link{dstretchedexp}} degree distribution.}
  \item{akaikeprob}{ vector of the probability densities for the degrees of the nodes found in the network, found using the Akaike weights and 5 tested degree distributions.}
}
\author{William P. Kelly and Michael P.H. Stumpf}
\examples{
## Generate a random network with 50 nodes and 400 edges
nodes <- 50
edges <- 400
net<-matrix(ceiling(nodes*runif(2*edges)),ncol=2)

## Find the Akaike weights based on the maximum likelihoods for the five given distributions.
akaike <- mmi.akaike(net)

## Generate a graph for the degree distribution of the data, from the Akaike weights and standard tested models.
probability <- akaike$akaikeprob
degrees <- seq(1:length(probability))

plot(degrees, probability)
}
