\name{mmi.conf}
\alias{mmi.conf}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Multi-Model Inference (MMI) bootstrap replicates}
\description{
This routine determines the confidence intervals of the best fit of five probability models to the degree distribution of a potentially incomplete network, identifies the best model, and predicts the optimal degree distribution function using MMI. Confidence intervals are obtained using a bootstrap on the degree sequence. 
The output is a list for each replicate (which is a random network drawn with replacement from the nodes found in the provided network) matching the output found for \code{\link{mmi.akaike}}.
}
\usage{
mmi.conf(net,replicates=100,parrand=c(0.1,100),parexp=c(0.05,1),parpow=c(1.01,10),parlnorm=c(10,10),parstrexp=c(5,10),nodes=1)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{net}{ network data as edgelist.}
  \item{replicates}{ the number of bootstrap replicates that are generated for the data.}
  \item{parrand}{ list with 2 elements detailing the initial boundaries for the search for the parameter of a Poisson degree distribution.}
  \item{parexp}{ list with 2 elements detailing the initial boundaries for the search for the parameter of an Exponential degree distribution. }
  \item{parpow}{ list with 2 elements detailing the initial boundaries for the search for the parameter of a power law degree distribution. }
  \item{parlnorm}{ list with 2 elements detailing the initial points used for the optimisation routine for the parameters of a Lognormal degree distribution.}
  \item{parstrexp}{ list with 2 elements detailing the initial points used for the optimisation routine for the parameters of a Stretched exponential degree distribution.}
  \item{nodes}{ the complete size of the true network, which must be larger than the number of nodes found in \code{net} if subsampling is to be assumed.}
}
\details{
This function may be time consuming dependent on the size of \code{net}. It completes \code{\link{mmi.akaike}} a number of times equal to that specified with \code{replicates}.
}
\value{
  The function returns a list of output which matches that output by \code{\link{mmi.akaike}}.
  \code{\link{mmi.akaike}} outputs a list with components:
	  \item{random}{ Akaike weight for the \code{\link{drandom}} degree distribution.}
	  \item{exponential}{ Akaike weight for the \code{\link{dexpnetz}} degree distribution.}
	  \item{powerlaw}{ Akaike weight for the \code{\link{dpowerlaw}} degree distribution.}
	  \item{lognormal}{ Akaike weight for the \code{\link{dlognormal}} degree distribution.}
	  \item{stretchedexp}{ Akaike weight for the \code{\link{dstretchedexp}} degree distribution.}
	  \item{akaikeprob}{ vector of the probability densities for the degrees of the nodes found in the network, found using the Akaike weights and 5 tested degree distributions.}
}
\references{ M.P.H. Stumpf and T. Thorne, J.Integr.Bioinf. (\emph{in press}); M.P.H. Stumpf, C. Wiuf and R.M. May, PNAS, \bold{102}, 422--4224 (2005).}
\author{ William P. Kelly and Michael P.H. Stumpf }
\examples{
## Generate a Network with 100 nodes and 1000 edges
nodes<-seq(1:100)
edges<-matrix(sample(nodes,size=2000,replace=TRUE),ncol=2)

## Note: The degree sequence of this network should be approximately binomial.
result<-mmi.conf(edges,replicates=5)

## Generate a subnet containing only the interactions among nodes 1 to 20

le<-edges[,1][edges[,1]<=20 & edges[,2]<=20]
re<-edges[,2][edges[,1]<=20 & edges[,2]<=20]
subnet<-cbind(le,re)

## Number of nodes in subnet
s<-length(unique(c(le,re)))

## Now make inferences of the network from the subnet assuming it is the 
## correct network, and assuming that it is a subnet drawn from a network 
## with 100 node
res1<-mmi.conf(subnet,replicates=5)
res2<-mmi.conf(subnet,replicates=5,nodes=100)

## In general these will give rise to different results
}

