#Stretched exponential distribution function: defined on 2 parameters (a,m) for either greater than 0. Returns probability of observing k.
dstretchedexp <- function(k,param){
	a <- param[1]
	m <- param[2]
	#Condition on a being between 0 (power law) and 1 (exponential)
	if(0<a & 1>a){
	#if(a > 0){
	if(m > 0){
	prob <- (a*(k/m)^{a-1})*exp(-(k/m)^a)/m
	#if(is.nan(prob)){warning("dstretchedexp: prob is NaN")}
	#if(is.infinite(prob)){warning("dstretchedexp: prob is Inf")}
	}else{return(0)}
	}else{return(0)}
	return(prob)
	}
	
#Log normal: just altering presumed input from standard function.
dlognormal <- function(k,param){
 	a <- param[1]; m <- param[2]
 	if(m > 0){
		prob<-dlnorm(k,a,m)
		#if(is.nan(prob)){
		#	prob <- 0
		#	warning("dlognormal: prob is NaN so has been coerced to 0")}
		#if(is.infinite(prob)){warning("dlognormal: prob is Inf")}
		}else{prob <- 0}
 	return(prob)
	}

#Power law probability distribution.	
dpowerlaw <- function(k,param){
	a <- param[1]
	if(a > 0){
    prob <- k^{-a}/zeta(a)
 	#if(is.nan(prob)){warning("dpowerlaw: prob is NaN")}
	#if(is.infinite(prob)){warning("dpowerlaw: prob is Inf")}   
	}else{prob<-0}
	return(prob)
	}

#Exponential function: standard inbuilt function.
dexpnetz <- function(k,param){
	prob<-dexp(k,param)
	#if(is.nan(prob)){warning("dlognormal: prob is NaN")}
	#if(is.infinite(prob)){warning("dlognormal: prob is Inf")}
	return(prob)}

#Random graph is just a Poisson distribution, normalised later for discrete purposes.
drandom <- function(k,param){
	prob<-dpois(k,param)
	#if(is.nan(prob)){warning("drandom: prob is NaN")}
	#if(is.infinite(prob)){warning("drandom: prob is Inf")}
	return(prob)}
