mmi.interactomesize <- function(net,parrand=c(0.1,100),parexp=c(0.05,1),parpow=c(1.01,20),parlnorm=c(20,20),parstrexp=c(0.5,10),nodes=1,degree=FALSE,mmi=FALSE,IC="AIC"){
  if(mmi==FALSE){
  	mmiout <- mmi.likelihoods(net,parrand,parexp,parpow,parlnorm,parstrexp,nodes,degree)     	}else{mmiout <- net}
	
  S <- mmiout$sampled$samples
  N <- mmiout$sampled$nodes
  likvec <- c(mmiout$poisson$lik,mmiout$exponential$lik,mmiout$powerlaw$lik, mmiout$lognormal$lik,mmiout$stretchedexp$lik)
  #The number of parameters in each model (bespoke function).
  parvec<-c(1,1,1,2,2);
  if(IC=="AIC"){
	  AIC <- 2*(-likvec + parvec)
	  minAIC <- min(AIC)
	  delta <- (AIC - minAIC)
	}else{
	  BIC <- 2*(-likvec) + parvec*log(N)
	  minBIC <- min(BIC)
	  delta <- (BIC - minBIC)
	  }

  Aweight <- exp(-0.5*delta)/(sum(exp(-0.5*delta)))
  
  ## Find the degree distribution using the Aweights
  maxdeg <- N - 1
  akaikedegreedist <- rep(0,maxdeg)
  cvec<-seq(1:maxdeg)
  varlist <- c(mmiout$poisson$var,mmiout$exponential$var,mmiout$powerlaw$var, mmiout$lognormal$var,mmiout$stretchedexp$var)
  norm.drandom <- sum(drandom(cvec,varlist[1]))
  norm.dexpnetz <-sum(dexpnetz(cvec,varlist[2]))
  norm.dpowerlaw<- sum(dpowerlaw(cvec,varlist[3]))
  norm.dlognormal<-sum(dlnorm(cvec,c(varlist[4],varlist[5])))
  norm.dstretchedexp<-sum(dstretchedexp(cvec,c(varlist[6],varlist[7])))
  n <- c(norm.drandom,norm.dexpnetz,norm.dpowerlaw,norm.dlognormal,norm.dstretchedexp)
  A <- Aweight/n
  ## Compute the probabilities for each degree  
  for (i in 1:maxdeg) {
    akaikedegreedist[i] <- A[1]*drandom(i,varlist[1])+A[2]*dexpnetz(i,varlist[2])+A[3]*dpowerlaw(i,varlist[3])+A[4]*dlognormal(i,c(varlist[4],varlist[5]))+A[5]*dstretchedexp(i,c(varlist[6],varlist[7]))
  }
  akaikedegreedist <-   akaikedegreedist/sum(akaikedegreedist)
  
  size <- {}
  size[1] <- sum(cvec*drandom(cvec,varlist[1]))/norm.drandom
  size[2] <- sum(cvec*dexpnetz(cvec,varlist[2]))/norm.dexpnetz
  size[3] <- sum(cvec*dpowerlaw(cvec,varlist[3]))/norm.dpowerlaw
  size[4] <- sum(cvec*dlnorm(cvec,c(varlist[4],varlist[5])))/norm.dlognormal
  size[5] <- sum(cvec*dstretchedexp(cvec,c(varlist[6],varlist[7])))/norm.dstretchedexp
  size[6] <- sum(cvec*akaikedegreedist)

  size <- N*size
  
  return(list(poisson=size[1],exponential=size[2],powerlaw=size[3],lognormal=size[4],stretchedexp=size[5], akaikeprob=size[6])) 
}
 

