plot.mmiconf <- function(net,replicates,mmiconf=NULL, ...){
		if(is.null(mmiconf)){
			out <- mmi.conf(net,replicates)
		}else{
			out <- mmiconf	
		}
	netakaike <- mmi.akaike(net)
	netdeg <- degseq(net)

	thick <- 6
	ylimit <- c(0,1)
	maxpdeg <- sum(netdeg$degree) - 1
	maxdeg<-length(netdeg$degree)
	nodes <- sum(netdeg$degree)

	plot(seq(1:maxdeg),netakaike$akaikeprob[1:maxdeg],xlab="Node Degree",ylab="Probability",type = "h", col = "red",lwd=thick,main="Degree distributions - network and resampled network data",ylim=ylimit, ...)
	#points(netdeg$degree/nodes,pch='x',col='blue')
	for(i in 1:replicates){
		out[[i]]$akaikeprob[1:maxdeg]
		points(out[[i]]$akaikeprob[1:maxdeg],pch=i)
		}
	}