#Initialise the package, which should have already been KROGANleted.
#library(netZ)

## All the data available in the file can be loaded using the following command. Or a subset can also be used if all the data is not required.
#datanamelist <- c('pm10688190','pm10900456','pm11283351','pm11805826','pm11805837','pm12052880','pm12150911','pm14574415','pm14660704','pm14759368','pm16093310','pm16319894','pm16429126','pm16554755','pm17200106','pm17634282')
#data(list=datanamelist)
## eg data(list=datanamelist[1:3])

## Alternatively, we can just load the KROGAN dataset from Krogan et al (2006)
data(pm16554755)

## Example dataset regarding reported complexes and PPIs found in Krogan et al (2006) which is pubmedid 16554755. This can be loaded using:
KROGAN <- pm16554755

## Print out first 5 items of edge list to see format for all network sets
KROGAN[1:5,]

## Find the degree sequence, and other sampling information for the dataset
KROGANdeg <- degseq(KROGAN)

## The degree sequence include information on the number of edges, and direction if the vectors are input for a directed network:
KROGANdeg

## Plot the degree distribution, in this using both frequency-degree and rank-degree plots on log-log scale, using the degree sequence entry from KROGANdeg.
plot.freqrank(KROGANdeg$degree,freq=TRUE)

## See Figure to see the expected output. It can be seen that the data have a large number of nodes with low degree, and a smaller collection of proteins with a large number of neighbours, which may suggest a fat tailed distribution. 
## However, in order to test this, likelihood analysis is performed, rather than just using this diagnostic plot.

## Find the likelihoods for the standard degree distribution models: power law, random (Poisson), exponential, log normal, and stretched exponential.
KROGANlike <- mmi.likelihoods(KROGAN)

## Now that MLE has been used to fit the standard models, the same rank and frequency plots can be overlaid with the best fit lines from the different models.
par(mfcol=c(1,2))
plot.modelfreq(KROGAN, KROGANlike,title="")
plot.modelrank(KROGAN, KROGANlike,title="")
par(mfcol=c(1,1))

## Now we will use the likelihoods and parameter values to find the Akaike weights, 
## to determine the model selected to represent the data, presented in the following collection of plots.
plot.modelsummary(KROGANlike)

## Alternatively, the Akaike weights can be returned using the following function. The below two commands are identical, although the second will take longer to calculate.
KROGANakaike <- mmi.akaike(KROGANlike,mmi=TRUE)
# KROGANakaike <- mmi.akaike(KROGAN,mmi=FALSE)

## Finally, in order to better appreciate how the models used represent the degree sequences, these show the probability density functions
## (which as throughout have been discretised and truncated to reflect the number of nodes in the data) and how they match against the observed data (shown in 'x'). 
## Alongside the  tested models, the Akaike weighted pdf is also shown (which is a combination of all the tested models according to the weights found in KROGANakaike).
plot.degreesequences(KROGANlike,KROGANakaike,KROGANdeg)
