\name{mmi.interactomesize}
\alias{mmi.interactomesize}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Find the Akaike Weights and Model Averaged Degree Distribution}
\description{
This function takes a net (as an edge list), or a degree list (as a vector where entry \code{i} details the number of nodes with degree \code{i}), and performs likelihood analysis as found in \code{\link{mmi.likelihoods}}. The output uses the maximum likelihood parameter estimates to give an estimate of the complete interactome size. This can also be used on likelihoods estimated from binomially subsampled data through use of the nodes variable.}
\usage{
mmi.interactomesize(net,parrand=c(0.1,100),parexp=c(0.01,1),parpow=c(1.01,10),parlnorm=c(1,1),parstrexp=c(1,1),nodes=1,degree=FALSE,mmi=FALSE,IC="AIC")
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{net}{ an edge list for a network or when \code{degree = TRUE} a degree list. Alternatively this can be the output from \code{\link{mmi.likelihoods}} if \code{mmi = TRUE}.}
  \item{parrand}{ vector describing the \code{min} and \code{max} for the \code{\link{drandom}} distribution parameter, over which the likelihood is assessed.}
  \item{parexp}{ vector describing the \code{min} and \code{max} for the \code{\link{dexpnetz}} distribution parameter.}
  \item{parpow}{ vector describing the \code{min} and \code{max} for the \code{\link{dpowerlaw}} distribution parameter.}
  \item{parlnorm}{ vector describing the starting parameter values for the \code{\link{dlognormal}} distribution parameter, from where the optimisation is seeded.}
  \item{parstrexp}{ vector describing the starting parameter values for the \code{\link{dstretchedexp}} distribution parameter, from where the optimisation is seeded.}
  \item{nodes}{ the complete number of nodes found in the network, if data is viewed as a subsample of the complete network, using \code{\link{subsample}}. This is only necessary if the parameter values, as opposed to the maximum likelihoods, are sought for each function.}
  \item{degree}{ detailing whether \code{net} is a degree sequence.}
  \item{mmi}{ details wheterh \code{net} is the output for a network from \code{\link{mmi.likelihoods}}.}
  \item{IC}{ string detailing which information criterion should be used, either \code{AIC} or \code{BIC}.}
}
\value{
A list with components:
  \item{random}{ interactome size for the \code{\link{drandom}} degree distribution.}
  \item{exponential}{ interactome size for the \code{\link{dexpnetz}} degree distribution.}
  \item{powerlaw}{ interactome size for the \code{\link{dpowerlaw}} degree distribution.}
  \item{lognormal}{ interactome size for the \code{\link{dlognormal}} degree distribution.}
  \item{stretchedexp}{ interactome size for the \code{\link{dstretchedexp}} degree distribution.}
  \item{akaike}{ interactome size for the weighted Akaike distribution.}
}
\author{William P. Kelly and Michael P.H. Stumpf}
\examples{
## Generate a random network with 50 nodes and 400 edges
nodes <- 50
edges <- 400
net<-matrix(ceiling(nodes*runif(2*edges)),ncol=2)

## Find the maximum likelihoods for the five given distributions and predict the size if sampled from a network with 100 nodes.
size <- mmi.interactomesize(net,nodes=100)
}
