\name{plot.degreesequences}
\alias{plot.degreesequences}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Plots the density functions for the MLE parameters for the standard models.}
\description{This function plots 6 graphs showing the observed network data and the probability density functions for the tested models: Poisson (\code{\link{drandom}}), exponential (\code{\link{dexpnetz}}), power law (\code{\link{dpowerlaw}}), log normal (\code{\link{dlognormal}}), and stretched exponential (\code{\link{dstretchedexp}}). The network can either be given, or the output from \code{\link{mmi.likelihoods}}, \code{\link{mmi.akaike}}, and \code{\link{degseq}} for a given \code{net}.}
\usage{plot.degreesequences(netlike=NULL,netakaike=NULL,netdeg=NULL,net=NULL,thick=2,ylimit=c(0,1), ...)}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{netlike}{ the likelihood output for a given \code{net} dataset.}
  \item{netakaike}{ the output for a given \code{net} from \code{\link{mmi.akaike}}.}
  \item{netdeg}{ the output for a given \code{net} from \code{\link{degseq}}.}
  \item{net}{ a network edgeless. If given, the previous entries can be left as \code{NULL}.}
  \item{thick}{ a value detailing the thickness of the bars shown in the plots.}
  \item{ylimit}{ a vector presenting the \code{limit} for the plots.}
}
\value{ Returns a set of plots, with the degree distribution densities (best fit for the \code{net} using the MLEs from \code{\link{mmi.likelihoods}}) and the Akaike weighted output. The observed data are overlaid on the plots using black 'x'.}
\author{William P. Kelly and Michael P.H. Stumpf}

\examples{
## Generate a random network with 50 nodes and 300 edges
nodes <- 50
edges <- 300
net<-matrix(ceiling(nodes*runif(2*edges)),ncol=2)

## Plot the best fit degree distributions
plot.degreesequences(net=net)

## Produce the same output, but by using the individual functions
#netdeg <- degseq(net)
#netlike <- mmi.likelihoods(net)
#netakaike <- mmi.akaike(netlike, mmi=TRUE)
#plot.degreesequences(netlike,netakaike,netdeg)
}

\seealso{ \code{\link{plot}}}
\keyword{utilities}
