\name{plot.freqrank}
\alias{plot.freqrank}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Plots rank-degree, and frequency-degree, plots for network data}
\description{
This function can be used to plot rank-degree plots for a given network dataset (as well as frequency-degree plots).
}
\usage{
plot.freqrank(etdeg,freq=FALSE,rank=TRUE, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{netdeg}{ a degree sequence for a given \code{net} dataset, found from \code{net} using \code{\link{degseq}}.}
  \item{freq}{ logical that determines whether a frequency-degree plot is output.}
  \item{rank}{ logical that determines whether a rank-degree plot is output.}
}

\value{
Returns a plot showing a log-log plot for the degree sequence data presented.
}
\author{William P. Kelly and Michael P.H. Stumpf}

\examples{
## Generate a random network with 50 nodes and 300 edges
nodes <- 50
edges <- 300
net<-matrix(ceiling(nodes*runif(2*edges)),ncol=2)

## Calculate its degree sequence:
dseq <- degseq(net)$degree

## Plot a rank-degree plot
plot.freqrank(dseq)

## Plot rank-degree and frequency-degree plots
plot.freqrank(dseq,freq=TRUE)
}
\seealso{ \code{\link{plot}}}
\keyword{utilities}
