\name{plot.modelfreq}
\alias{plot.modelfreq}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Plot a frequency-degree graph for network data and standard models}
\description{
This produces a plot for the MLE parameter values of the standard models found in \code{\link{distributions}} and the observed data on a log-log plot for degree against frequency.
}
\usage{
plot.modelfreq(net,netlike=NULL,nodethick=0.4,title="Expected Frequency-Degree Plots for MLE Models",textsize=0.6, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{net}{ a edgelist for the network.}
  \item{netlike}{ output for the \code{net} data from \code{\link{mmi.likelihoods}}.}
  \item{nodethick}{ value for the thickness of the datapoints for the observed data.}
  \item{tite}{ string detailing the title for the plot.}
}

\value{
Returns a plot showing the observed data (black dots) against the best fit expected returns for the standard tested distributions.
}
\author{William P. Kelly and Michael P.H. Stumpf}

\examples{
## Generate a random network with 50 nodes and 300 edges
nodes <- 50
edges <- 300
net<-matrix(ceiling(nodes*runif(2*edges)),ncol=2)

## Plot output and best-fit expected degree sequences for different degree models.
plot.modelfreq(net)
}
\seealso{ \code{\link{plot}}}
\keyword{utilities}
