\name{plot.modelsummary}
\alias{plot.modelsummary}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Plots a collection of diagnostic plots}
\description{
This function produces output showing the degree sequence, the Akaike weights, and the maximum likelihood estimates found for the models detailed in {\code{\link{distributions}}}.
}
\usage{
plot.modelsummary(net,degree=FALSE,likelihood=TRUE,IC="AIC", ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{net}{ a edgelist for the network, or if \code{degree=TRUE} the degree sequence, or if \code{likelihood=TRUE} the output from \code{\link{mmi.likelihoods}}.}
  \item{degree}{ logical detailing the form of \code{net}. \code{TRUE} if \code{net} is a degree sequence, the \code{degree} output from \code{\link{degseq}}.}
  \item{likelihood}{ logical detailing the form of \code{net}. \code{TRUE} if \code{net} is the output for the required network from \code{\link{mmi.likelihoods}}.}
  \item{IC}{ string detailing which information criterion should be used, either \code{AIC} or \code{BIC}.}
  \item{. . .}{ arguments which can be passed to \code{\link{plot}}.}
}

\value{
Returns 4 plots on the same screen detailing the model weights, likelihoods, and the degree sequence for a given dataset.
}
\author{William P. Kelly and Michael P.H. Stumpf}

\examples{
## Generate a random network with 50 nodes and 300 edges
nodes <- 50
edges <- 300
net<-matrix(ceiling(nodes*runif(2*edges)),ncol=2)

netlike <- mmi.likelihoods(net)
netdeg <- degseq(net)$degree

## Plot the model summary for the standard models.
plot.modelsummary(net,likelihood=FALSE)
plot.modelsummary(netlike,likelihood=TRUE)
plot.modelsummary(netdeg,degree=TRUE,likelihood=FALSE)
}
\seealso{ \code{\link{plot}}}
\keyword{utilities}
