\name{subsample}
\alias{subsample}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Binomial Subsampled Network Degree Distributions.}
\description{
This function takes a standard degree distribution (as defined in \code{\link{distributions}}) which takes a degree \code{k} and a vector of parameters \code{var} and returns the probability of any degree given that the sample is a subsample of \code{S} nodes from a network consisting of \code{N} nodes. Accordingly, it is possible to transform any standard distribution into one that can be viewed as a subsample of the data, and the parameter estimates found in \code{\link{mmi.likelihoods}} will reflect the complete network, as opposed to the sample given.
}
\usage{
subsample(k,S,N,dist,var)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{k}{ a vector of degrees at which the probability density is sought.}
  \item{S}{ the number of nodes found in the sampled data.}
  \item{N}{ the number of nodes in the complete network.}
  \item{dist}{ a probability distribution which takes arguments \code{k}, a vector of degrees, and \code{var} a vector of parameters for the distribution.}
  \item{var}{ the vector of parameters necessary for the function \code{dist}.}
}
\value{
This function returns a probability density for \code{dist} under the given subsampling constraints.
}
\author{William P. Kelly and Michael P.H. Stumpf}

\examples{
## Find the probability of each degree for a powerlaw distribution.
dist <- dpowerlaw; var <- 2.2; S <- 40; N <- 50

k <- seq(1:39)

probability <- subsample(k,S,N,dist,var)

## A plot of the probability distribution under the given model, compared to that for a sample with no subsampling (N = S).
plot(probability, k)
lines(dpowerlaw(k,var),k)
}
