## ##############################################################
## 
## Starting from an oligo-table, calculate distances between sequences

## Directories
#dir.main <- '/nas/biocomp/users/jerae/oldbiocomp3/projects/PromDivAfterDupl/JVH/'
dir.main <- '~/Desktop/test_poisson_dist/JVH'
dir.R.scripts <- file.path(dir.main, 'R-scripts')
dir.data <- file.path(dir.main, 'data')

## load the libraries
source(file.path(dir.R.scripts, 'poisson_distances.R'))

## load the oligo counts
prefix <- 'yeast_PHO_up_800_twice'
ol <- 3
str <- '-1str'
file.name <- paste(prefix, '_l', ol, str,'.tab', sep='')
file.data <- file.path(dir.data,file.name)
x <- read.table(file.data, sep='\t',header=T,row.names=1)

## Calculate Poisson distance
poisson.dist.over.add <- dist.poisson(x,over=T,product=F)
poisson.dist.distinct.add <- dist.poisson(x,over=F,product=F)

poisson.sim.add <- sim.poisson(x,product=F)
poisson.sim.add.d <- max(poisson.sim.add) - poisson.sim.add

## Calculate a tree from the Poisson dist
par(mfrow=c(3,1))
plot(hclust(as.dist(poisson.dist.over.add),method="ward"))
plot(hclust(as.dist(poisson.dist.distinct.add),method="ward"))
plot(hclust(as.dist(poisson.sim.add.d),method="ward"))
par(mfrow=c(1,1))


