################################################################
##
include makefiles/02_motifs.mk
MAKEFILE=makefiles/02.1_motifs_peak_coverage_per_class.mk

SLICE_FROM=+150
SLICE_TO=+449
SLICE_NAME=${SLICE_FROM}_${SLICE_TO}
PATTERN_PREFIX=SWEMBL_ES_indiff_C3_BN_vs_F4_RNAse_R0.002_SICERmatch_summits_8nt_ci50-1str-noov_bg_mkv0
PATTERN_CLUST_NB=12
PATTERN_CLUSTERS=analysis/motifs/position_analysis/${PATTERN_PREFIX}/${PATTERN_PREFIX}_clusters_complete_k${PATTERN_CLUST_NB}.tab
PATTERN_OCC_DIR=analysis/motifs/position_analysis/${PATTERN_PREFIX}/occurrences_per_slice
PATTERN_FILE=${PATTERN_OCC_DIR}/${PATTERN_PREFIX}_patterns_k${PATTERN_CLUST_NB}.tab
PATTERN_OCC_TABLE=${PATTERN_OCC_DIR}/${PATTERN_PREFIX}_slice_${SLICE_NAME}.tab
dnapat_param:
	@echo "Patterns for counting occurrences per slice"
	@echo "	PROF_SEQ		${PROF_SEQ}"
	@echo "	SLICE_FROM		${SLICE_FROM}"
	@echo "	SLICE_TO		${SLICE_TO}"
	@echo "	SLICE_NAME		${SLICE_NAME}"
	@echo "	PATTERN_CLUSTERS	${PATTERN_CLUSTERS}"
	@echo "	PATTERN_OCC_DIR		${PATTERN_OCC_DIR}"
	@echo "	PATTERN_FILE		${PATTERN_FILE}"
	@echo "	PATTERN_OCC_TABLE	${PATTERN_OCC_TABLE}"

## Extract patterns from pattern cluster file. Concatenate pattern and
## cluster as pattern identifier.
patterns:
	@echo "Extracting pattern file"
	@mkdir -p ${PATTERN_OCC_DIR}
	@awk -F'\t' '$$1 != "seq" {print $$1"\t"$$1".cluster"$$2}' ${PATTERN_CLUSTERS} > ${PATTERN_FILE}
	@echo "Pattern file"
	@echo "	${PATTERN_FILE}"

dnapat_one_slice:
	@echo "Counting occurrences per slice	${SLICE_NAME}"
	@mkdir -p ${PATTERN_OCC_DIR}
	sub-sequence -i ${PROF_SEQ} \
		-from ${SLICE_FROM} -to ${SLICE_TO} -origin center \
		| dna-pattern -v ${V} -pl ${PATTERN_FILE} -return table,total -noov -1str -subst 0 \
		-o ${PATTERN_OCC_TABLE}
	@echo "	${PATTERN_OCC_TABLE}"

DNAPAT_TASK=dnapat_one_slice
dnapat_all_slices:
	@${MAKE} ${DNAPAT_TASK} SLICE_FROM=-450 SLICE_TO=-151
	@${MAKE} ${DNAPAT_TASK} SLICE_FROM=-150 SLICE_TO=149
	@${MAKE} ${DNAPAT_TASK} SLICE_FROM=+150 SLICE_TO=+449




