################################################################
## Index all results from the analysis of replication origins

include scripts/makefiles/02_motifs.mk
MAKEFILE=scripts/makefiles/09_index_results.mk

################################################################
## Stats on the reads
READ_COUNTS=${DIR_READS}/lines_per_bed.txt
count_reads:
	@echo
	@echo "Counting lines per read file, result in ${READ_COUNTS}"
	wc -l ${DIR_READS}/*.bed > ${READ_COUNTS}
	@echo "	${READ_COUNTS}"

################################################################
## Count peak numbers returned by the different peak-callers in each
## test set.
PEAK_COUNT_TABLE_HTML=html/peak_counts.html
count_peaks_html:
	@echo
	@echo "Synthetic table of peak counts"
	@echo "<html>" > ${PEAK_COUNT_TABLE_HTML}
	@echo "<title>Replication origins</title>" >> ${PEAK_COUNT_TABLE_HTML}
	@echo "<link rel='stylesheet' type='text/css' href='course.css' media='screen,print'/>"  >> ${PEAK_COUNT_TABLE_HTML}
	@echo "<body>" >> ${PEAK_COUNT_TABLE_HTML}
	@echo "<h1>Peak counts</h1>" >> ${PEAK_COUNT_TABLE_HTML}
	@${MAKE} _peak_count_table_html
	@echo "</body>" >> ${PEAK_COUNT_TABLE_HTML}
	@echo "</html>" >> ${PEAK_COUNT_TABLE_HTML}
	@echo "	${PEAK_COUNT_TABLE_HTML}"

_peak_count_table_html:
	@echo "<hr><h2>Peak counts</h2>" >> ${INDEX_FILE}
	@echo "<table>" >> ${PEAK_COUNT_TABLE_HTML}
	@echo "<tr valign='top'>" >>  ${PEAK_COUNT_TABLE_HTML}
	@echo "<th>ANALYSIS</th>" >>  ${PEAK_COUNT_TABLE_HTML}
	@echo "<th>TEST</th>" >>  ${PEAK_COUNT_TABLE_HTML}
	@echo "<th>CTRL</th>" >>  ${PEAK_COUNT_TABLE_HTML}
	@echo "<th>Test reads</th>" >>  ${PEAK_COUNT_TABLE_HTML}
	@echo "<th>Ctrl reads</th>" >>  ${PEAK_COUNT_TABLE_HTML}
	@echo "<th>SWEMBL R=${SWEMBL_R}</th>" >> ${PEAK_COUNT_TABLE_HTML}
	@echo "<th>SICER</th>" >> ${PEAK_COUNT_TABLE_HTML}
	@echo "<th>ORI peaks (SWEMBL inter SICER)</th>" >> ${PEAK_COUNT_TABLE_HTML}
	@echo "<th>ORI regions (SICER inter SWEMBL)</th>" >> ${PEAK_COUNT_TABLE_HTML}
	@echo "<th>MACS</th>" >> ${PEAK_COUNT_TABLE_HTML}
	@echo "<th>MACS + PeakSplitter</th>" >> ${PEAK_COUNT_TABLE_HTML}
	@echo "<th>Description</th>" >> ${PEAK_COUNT_TABLE_HTML}
	@${MAKE} iterate_analyses TASK=_count_peaks_one_analysis_html
	@echo "</table>" >> ${PEAK_COUNT_TABLE_HTML}

_count_peaks_one_analysis_html:
#	echo "TEMPORARILY INACTIVATED _count_peaks_one_analysis_html"
#
# temp:
	@echo "	Counting peaks	${ANALYSIS}	${TEST}	${CTRL}"
	@echo "<tr valign='top'>" >>  ${PEAK_COUNT_TABLE_HTML}
	@echo "<td>${ANALYSIS}</td>" >>  ${PEAK_COUNT_TABLE_HTML}
	@echo "<td>${TEST}</td>" >>  ${PEAK_COUNT_TABLE_HTML}
	@echo "<td>${CTRL}</td>" >>  ${PEAK_COUNT_TABLE_HTML}
	@echo "<td>" >>  ${PEAK_COUNT_TABLE_HTML}
	@${MAKE} _grep_read_number READS=${TEST_READS} >>  ${PEAK_COUNT_TABLE_HTML}
	@echo "<td>" >>  ${PEAK_COUNT_TABLE_HTML}
	@${MAKE} _grep_read_number READS=${CTRL_READS} >>  ${PEAK_COUNT_TABLE_HTML}
	@echo "<td>" >> ${PEAK_COUNT_TABLE_HTML}
	@${MAKE} _count_lines FILE=${SWEMBL_PEAKS}.bed >> ${PEAK_COUNT_TABLE_HTML}
	@echo "</td><td>" >> ${PEAK_COUNT_TABLE_HTML}
	@${MAKE} _count_lines FILE=${SICER_ISLANDS_SORTED}.bed >> ${PEAK_COUNT_TABLE_HTML}
	@echo "</td><td>" >> ${PEAK_COUNT_TABLE_HTML}
	@${MAKE} _count_lines FILE=${ORI_PEAKS}.bed >> ${PEAK_COUNT_TABLE_HTML}
	@echo "</td><td>" >> ${PEAK_COUNT_TABLE_HTML}
	@${MAKE} _count_lines FILE=${ORI_REGIONS}.bed >> ${PEAK_COUNT_TABLE_HTML}
	@echo "</td><td>" >> ${PEAK_COUNT_TABLE_HTML}
	@${MAKE} _count_lines FILE=${MACS_PEAKS}.bed >> ${PEAK_COUNT_TABLE_HTML}
	@echo "</td><td>" >> ${PEAK_COUNT_TABLE_HTML}
	@${MAKE} _count_lines FILE=${MACS_SUBPEAKS}.bed >> ${PEAK_COUNT_TABLE_HTML}
	@echo "</td>" >> ${PEAK_COUNT_TABLE_HTML}
	@echo "<td>${ANALYSIS_DESCR}</td>" >> ${PEAK_COUNT_TABLE_HTML}
	@echo "</tr>" >>  ${PEAK_COUNT_TABLE_HTML}

_grep_read_number:
	if [ -e "${READS}" ] ; then \
		grep ${READS} ${READ_COUNTS} | awk '{print $$1}' ; \
	else \
		echo "missing file" ; \
	fi

# ## Generate a tab-delimited file with peak counts
# PEAK_COUNT_TAB=analysis/peaks/peak_counts.tab
# count_peaks:
# 	@echo
# 	@echo "Synthetic table of peak counts"
# 	@echo "#TEST" >>  ${PEAK_COUNT_TAB}
# 	@echo "\tTest reads" >>  ${PEAK_COUNT_TAB}
# 	@echo "\tCTRL" >>  ${PEAK_COUNT_TAB}
# 	@echo "\tCtrl reads" >>  ${PEAK_COUNT_TAB}
# 	@echo "\tSWEMBL R=${SWEMBL_R}" >> ${PEAK_COUNT_TAB}
# 	@echo "\tMACS" >> ${PEAK_COUNT_TAB}
# 	@echo "\tMACS + PeakSplitter\t" >> ${PEAK_COUNT_TAB}
# 	@${MAKE} iterate_analyses TASK=_count_peaks_one_analysis
# 	@echo ${PEAK_COUNT_TAB}
# 	@text-to-html -i ${PEAK_COUNT_TAB} > ${PEAK_COUNT_TABLE_HTML}
# 	@echo ${PEAK_COUNT_TABLE_HTML}

# _count_peaks_one_analysis:
# 	@echo "	Counting peaks	${ANALYSIS}	${TEST}	${CTRL}"
# 	@echo "${TEST}" >>  ${PEAK_COUNT_TAB}
# 	@echo "\t" >>  ${PEAK_COUNT_TAB}
# 	@${MAKE} _grep_read_number READS=${TEST_READS} >>  ${PEAK_COUNT_TAB}
# 	@echo "\t${CTRL}" >>  ${PEAK_COUNT_TAB}
# 	@echo "\t" >>  ${PEAK_COUNT_TAB}
# 	@${MAKE} _grep_read_number READS=${CTRL_READS} >>  ${PEAK_COUNT_TAB}
# 	@echo "\t" >> ${PEAK_COUNT_TAB}
# 	@${MAKE} _count_lines FILE=${SWEMBL_PEAKS}.bed >> ${PEAK_COUNT_TAB}
# 	@echo "\t" >> ${PEAK_COUNT_TAB}
# 	@${MAKE} _count_lines FILE=${MACS_PEAKS}.bed >> ${PEAK_COUNT_TAB}
# 	@echo "</td><td>" >> ${PEAK_COUNT_TAB}
# 	@${MAKE} _count_lines FILE=${MACS_SUBPEAKS}.bed >> ${PEAK_COUNT_TAB}

#FILE_LINES=`wc -l ${FILE} | awk '{print $$1}'`
#_count_lines:
#	@echo "${FILE_LINES}"

_count_lines:
	if [ -e "${FILE}" ] ; then \
		wc -l ${FILE} | awk '{print $$1}' ; \
	else \
		echo "<font color='red'>Missing file</font>" ; \
	fi

################################################################
## Generate an index file
INDEX_FILE=html/home.html
DATE=`date +%Y-%m-%d_%Hh%M`
index:
	@echo
	@echo "Indexing results"
	@echo "<html>" > ${INDEX_FILE}
	@echo "<head>" >> ${INDEX_FILE}
	@echo "<title>Replication origins</title>" >> ${INDEX_FILE}
	@echo "<link rel='stylesheet' type='text/css' href='course.css' media='screen,print'/>"  >> ${INDEX_FILE}
	@echo "</head>" >> ${INDEX_FILE}
	@echo "<body>" >> ${INDEX_FILE}
	@echo "<h1>Analysis of replication origins</h1>" >> ${INDEX_FILE}
	@echo "<p>Data from Christelle Cayrou and Marcel Mechali</p>" >> ${INDEX_FILE}
	@echo "<p>Analysis by Beno&icirc;t Ballester and Jacques van Helden</p>" >> ${INDEX_FILE}
	@echo "<p>Last update: ${DATE}</p>" >> ${INDEX_FILE}
	@${MAKE} _index_reads
	@${MAKE} _index_peaks
	@echo "<hr><a name='enrichment'></a><h2>Peak enrichment</h2>" >> ${INDEX_FILE}
	@cat html/peak_enrichment.html >> ${INDEX_FILE}
	@echo "<hr><a name='g4'></a>" >> ${INDEX_FILE}
	@cat html/g4_motifs.html >> ${INDEX_FILE}
	@echo "<hr>" >> ${INDEX_FILE}
	@echo "</body>" >> ${INDEX_FILE}
	@echo "</html>" >> ${INDEX_FILE}
	@echo "	${INDEX_FILE}"

## Index read files (test + input reads)
_index_reads:
	@echo
	@echo "Indexing reads"
	@echo "<hr><a name='reads'></a><h2>Reads</h2>" >> ${INDEX_FILE}
	@echo "<table>" >> ${INDEX_FILE}
	@echo "<tr valign='top'>" >> ${INDEX_FILE}
	@echo "<th>Name</th>" >> ${INDEX_FILE}
	@echo "<th width='200'>File</th>" >> ${INDEX_FILE}
	@echo "<th>Nb reads</th>" >> ${INDEX_FILE}
	@echo "<th>Organism</th>" >> ${INDEX_FILE}
	@echo "<th>Genome</th>" >> ${INDEX_FILE}
	@echo "<th>Alias</th>" >> ${INDEX_FILE}
	@echo "<th>Cell type</th>" >> ${INDEX_FILE}
	@echo "<th>Treatment</th>" >> ${INDEX_FILE}
	@echo "<th>Description</th>" >> ${INDEX_FILE}
	@echo "</tr>" >> ${INDEX_FILE}
	@${MAKE} iterate_reads READ_TASK=_index_reads_one_set
	@echo "</table>"  >> ${INDEX_FILE}

_index_reads_one_set:
	@echo "	Indexing test reads	${READS}	"
	@echo "<tr valign='top'>" >> ${INDEX_FILE}
	@echo "<td>${TEST}</td>" >> ${INDEX_FILE}
	@echo "<td>" >> ${INDEX_FILE}
	@${MAKE} _link_one_file_size FILE=${READS} TEXT='${READS}'
	@echo "</td>" >> ${INDEX_FILE}
#	@echo "<td>${NB_READS}</td>" >> ${INDEX_FILE}
	@echo "<td>" >> ${INDEX_FILE}
	@${MAKE} _grep_read_number READS=${READS} >>  ${INDEX_FILE}
	@echo "</td>" >> ${INDEX_FILE}
	@echo "<td>${ORGANISM}</td>" >> ${INDEX_FILE}
	@echo "<td>${GENOME}</td>" >> ${INDEX_FILE}
	@echo "<td>${ALIAS}</td>" >> ${INDEX_FILE}
	@echo "<td>${CELL_TYPE}</td>" >> ${INDEX_FILE}
	@echo "<td>${TREATMENT}</td>" >> ${INDEX_FILE}
	@echo "<td>${SAMPLE_DESCR}</td>" >> ${INDEX_FILE}
	@echo "</tr>" >> ${INDEX_FILE}


_index_peaks:
	@echo
	@echo "Indexing peaks"
	@echo "<a name='peaks'></a><hr><h2>Peak calling</h2>" >> ${INDEX_FILE}
	@cat html/method_peak-calling.html >> ${INDEX_FILE}
	@${MAKE} _peak_count_table_html PEAK_COUNT_TABLE_HTML=${INDEX_FILE}
	@${MAKE} _index_ori_peaks
	@${MAKE} _index_rand_peaks
	@${MAKE} _index_swembl_peaks
	@${MAKE} _index_sicer_regions
	@${MAKE} _index_macs_peaks


################################################################
## Index positional profiles of the OGRE motif
OGRE_W=${OGRE_SITES}_D_distrib
OGRE_C=${OGRE_SITES}_R_distrib
_index_ogre:
	@echo
	@echo "Indexing OGRE distribution profiles"
	@echo "<p><b>OGRE profiles</b> " >> ${INDEX_FILE}
	@${MAKE} _link_one_file FILE=${OGRE_DIR} TEXT='dir'
	@echo "<br>&nbsp;&nbsp;&nbsp;OGRE motif" >> ${INDEX_FILE}
	@${MAKE} _link_one_file FILE=${OGRE_PSSM} TEXT='tf'
	@${MAKE} _link_one_file FILE=${OGRE_LOGO} TEXT='logo'
	@echo "<br>&nbsp;&nbsp;&nbsp;strand W " >> ${INDEX_FILE}
	@${MAKE} _link_one_file FILE=${OGRE_W}.tab TEXT='tab' 
	@${MAKE} _link_one_file FILE=${OGRE_W}.${DISTRIB_IMG_FORMAT} TEXT='${DISTRIB_IMG_FORMAT}' 
	@echo "<br>&nbsp;&nbsp;&nbsp;strand C " >> ${INDEX_FILE}
	@${MAKE} _link_one_file FILE=${OGRE_C}.tab TEXT='tab' 
	@${MAKE} _link_one_file FILE=${OGRE_C}.${DISTRIB_IMG_FORMAT} TEXT='${DISTRIB_IMG_FORMAT}' 
	@echo "</p>" >> ${INDEX_FILE}

_index_peak_motifs:
	@${MAKE} _link_one_file FILE=${DIR_MOTIFS}/${MOTIF_PREFIX}_synthesis.html TEXT=motifs
#	@echo "<br/>[<a target='_blank' href='../${DIR_MOTIFS}/${MOTIF_PREFIX}_synthesis.html'>motifs</a>]" >> ${INDEX_FILE}

_index_positions:
	@${MAKE} _index_ogre
	@echo "<p>" >> ${INDEX_FILE}
	@echo "<b>De novo motifs (position-analysis)</b> " >> ${INDEX_FILE}
	@for l in ${POS_OLIGO_LENGTHS}; do \
		${MAKE} _index_positions_one_len POS_OL=$${l} ; \
	done
	@echo "</p>" >> ${INDEX_FILE}

_index_positions_one_len:
	@echo "<br/>Pos ${POS_OL}nt" >> ${INDEX_FILE}
	${MAKE} _index_positions_one_len_one_model POS_BG_SUFFIX= POS_BG_MODEL=uniform
	${MAKE} _index_positions_one_len_one_model POS_BG_SUFFIX=_bg_mkv0 POS_BG_MODEL=Bernouilli
	${MAKE} _index_positions_one_len_one_model POS_BG_SUFFIX=_bg_mkv-2 POS_BG_MODEL='Markov -2'

HEATMAP_FORMAT=pdf
POS_INDEX=${POS_DIR}/${POS_PREFIX}_index.html
POS_GRAPH_INDEX=${POS_DIR}/${POS_PREFIX}_graph_index.html
POS_TAB=${POS_DIR}/${POS_PREFIX}.tab
POS_CLUST_DIR=${POS_DIR}/${POS_PREFIX}_clusters
POS_HEATMAP=${POS_DIR}/${POS_PREFIX}_clusters/${POS_PREFIX}_profile_heatmap.${HEATMAP_FORMAT}
POS_FREQ_PROFILES=${POS_DIR}/${POS_PREFIX}_clusters/${POS_PREFIX}_freq_profiles_per_cluster.${HEATMAP_FORMAT}
POS_OCC_PROFILES=${POS_DIR}/${POS_PREFIX}_clusters/${POS_PREFIX}_occ_profiles_per_cluster.${HEATMAP_FORMAT}
_index_positions_one_len_one_model:
#	@${MAKE} _link_one_file FILE=${POS_DIR} TEXT='dir'
	@${MAKE} _link_one_file FILE=${POS_INDEX} TEXT='${POS_BG_MODEL}' 
#	@${MAKE} _link_one_file FILE=${POS_TAB} TEXT='tab'
#	@${MAKE} _link_one_file FILE=${POS_GRAPH_INDEX} TEXT='k-mer graphs'
#	@${MAKE} _link_one_file FILE=${POS_CLUST_DIR} TEXT='cluster dir'
#	@${MAKE} _link_one_file FILE=${POS_HEATMAP} TEXT='heatmap (${HEATMAP_FORMAT})'
#	@${MAKE} _link_one_file FILE=${POS_FREQ_PROFILES} TEXT='freq profiles (${HEATMAP_FORMAT})' ; \
#	if [ -e "${POS_FREQ_PROFILES_K12}" ] ; then \
#		${MAKE} _link_one_file FILE=${POS_FREQ_PROFILES_K12} TEXT='freq profiles (${HEATMAP_FORMAT})' ; \
#	else \
#		${MAKE} _link_one_file FILE=${POS_FREQ_PROFILES_K4} TEXT='freq profiles (${HEATMAP_FORMAT})' ; \
#	fi
#	@${MAKE} _link_one_file FILE=${POS_OCC_PROFILES} TEXT='freq profiles (${HEATMAP_FORMAT})' ; \
#	if [ -e "${POS_OCC_PROFILES_K12}" ] ; then \
#		${MAKE} _link_one_file FILE=${POS_OCC_PROFILES_K12} TEXT='freq profiles (${HEATMAP_FORMAT})' ; \
#	else \
#		${MAKE} _link_one_file FILE=${POS_OCC_PROFILES_K4} TEXT='freq profiles (${HEATMAP_FORMAT})' ; \
#	fi
#	@${MAKE} _link_one_file FILE=${POS_OCC_PROFILES} TEXT='occ profiles (${HEATMAP_FORMAT})'
#	@${MAKE} _link_one_file FILE=${POS_DIR}/position_clusters/profile_heatmap.pdf TEXT='heatmap (pdf)'


################################################################
## Generate a HTML link to a specified file, and check if the file
## exists (otherwise print it in red without link).
_link_one_file:
	if [ -e "${FILE}" ] ; then \
		echo "[<a href='../${FILE}'>${TEXT}</a>] " >> ${INDEX_FILE} ; \
	else \
		echo "[<font color='red'>${TEXT}</font>] " >> ${INDEX_FILE} ; \
	fi
#		echo "	missing file	${FILE}"; \

## Print a checked link towards a file + the number of lines
FILE_LINES=`wc -l ${FILE} | awk '{print $$1}'`
_link_one_file_lines:
	if [ -e "${FILE}" ] ; then \
		echo "${FILE_LINES} lines " >> ${INDEX_FILE} ; \
		echo "[<a href='../${FILE}'>${TEXT}</a>] " >> ${INDEX_FILE} ; \
	else echo "[<font color='red'>${TEXT}</font>] " >> ${INDEX_FILE} ; \
	fi

## Print a checked link towards a file + the file size
FILE_SIZE=`du -sh ${FILE} | awk '{print $$1}'`
_link_one_file_size:
	if [ -e "${FILE}" ] ; then \
		echo "${FILE_SIZE} " >> ${INDEX_FILE} ; \
		echo "[<a href='../${FILE}'>${TEXT}</a>] " >> ${INDEX_FILE} ; \
	else echo "[<font color='red'>${TEXT}</font>] " >> ${INDEX_FILE} ; \
	fi

## Print a checked link towards a sequence file (in fasta format) +
## the total sequence size
SEQ_SIZE=`sequence-lengths -units mb -i ${FILE} -sum | tail -1`
_link_one_file_fasta:
	if [ -e "${FILE}" ] ; then \
		echo "${SEQ_SIZE} " >> ${INDEX_FILE} ; \
		echo "[<a href='../${FILE}'>${TEXT}</a>] " >> ${INDEX_FILE} ; \
	else echo "[<font color='red'>${TEXT}</font>] " >> ${INDEX_FILE} ; \
	fi


## Print a checked link towards an image file + image icon
FILE_SIZE=`du -sh ${FILE} | awk '{print $$1}'`
_link_one_file_img:
	if [ -e "${FILE}" ] ; then \
		echo "<a href='../${FILE}'><img height='150' border=1 src='../${FILE}' alt='${TEXT}'></a> " >> ${INDEX_FILE} ; \
	else echo "[<font color='red'>${TEXT}</font>] " >> ${INDEX_FILE} ; \
	fi

################################################################
## Index MACS peak files
_index_macs_peaks:
	@echo
	@echo "Indexing MACS peaks"
	@echo "<a name='peaks_macs'></a><h3>MACS Peaks</h3>" >> ${INDEX_FILE}
	@echo "<table>"  >> ${INDEX_FILE}
	@echo "<tr valign='top'>" >> ${INDEX_FILE}
	@echo "<th>Test</th>" >> ${INDEX_FILE}
	@echo "<th>Control</th>" >> ${INDEX_FILE}
	@echo "<th>Directory</th>" >> ${INDEX_FILE}
	@echo "<th>Peaks</th>" >> ${INDEX_FILE}
	@echo "<th>Peak summits<br/>(${SUMMIT_EXT} bp each side)</th>" >> ${INDEX_FILE}
	@echo "<th>Subpeaks (from PeakSplitter)</th>" >> ${INDEX_FILE}
	@echo "<th>Subpeak summits<br/>(${SUMMIT_EXT} bp each side)</th>" >> ${INDEX_FILE}
	@echo "</tr>" >> ${INDEX_FILE}
	@${MAKE} iterate_analyses TASK=_index_macs_peaks_one_analysis
	@echo "</table>"  >> ${INDEX_FILE}

## Index MACS peaks for one test file
_index_macs_peaks_one_analysis:
	@echo "	Indexing MACS peaks	TEST=${TEST}	CTRL=${CTRL}	MACS_PEAKS_DIR=${MACS_PEAKS_DIR}"
	@echo "<tr valign='top'>" >> ${INDEX_FILE}
	@echo "<td>${TEST}</td>" >> ${INDEX_FILE}
	@echo "<td>${CTRL}</td>" >> ${INDEX_FILE}
	@echo "<td>" >> ${INDEX_FILE}
	@${MAKE} _link_one_file FILE=${MACS_PEAKS_DIR} TEXT='dir'
	@echo "</td><td>" >> ${INDEX_FILE}
	@${MAKE} _link_one_file_lines FILE=${MACS_PEAKS_SORTED}.bed TEXT=bed
	@echo "<br>" >> ${INDEX_FILE}
	@${MAKE} _link_one_file_fasta FILE=${MACS_PEAKS_SORTED}.fasta TEXT=fasta
#	@${MAKE} _index_peak_motifs PEAK_PREFIX=${MACS_PREFIX} SUMMITS='' PEAKS=${MACS_PEAKS_SORTED}
	@echo "<br>" >> ${INDEX_FILE}
	@${MAKE} _index_peak_distrib PEAKS=${MACS_PEAKS}
	@echo "</td><td>" >> ${INDEX_FILE}
	@${MAKE} _link_one_file_lines FILE=${MACS_SUMMITS_SORTED}.bed TEXT=bed
	@echo "<br>" >> ${INDEX_FILE}
	@${MAKE} _link_one_file_fasta FILE=${MACS_SUMMITS_SORTED}.fasta TEXT=fasta
#	@echo "<br>" >> ${INDEX_FILE}
#	@${MAKE} _index_peak_motifs PEAK_PREFIX=${MACS_PREFIX} SUMMITS='' PEAKS=${MACS_SUMMITS_SORTED}
	@${MAKE} _index_positions POS_SEQ_PREFIX=${MACS_PREFIX}_summits_sorted
	@echo "</td><td>" >> ${INDEX_FILE}
	@${MAKE} _link_one_file_lines FILE=${MACS_SUBPEAKS_SORTED}.bed TEXT=bed
	@echo "<br>" >> ${INDEX_FILE}
	@${MAKE} _link_one_file_fasta FILE=${MACS_SUBPEAKS_SORTED}.fasta TEXT=fasta
	@echo "</td><td>" >> ${INDEX_FILE}
	@${MAKE} _link_one_file_lines FILE=${MACS_SUBPEAKS_SUMMITS_SORTED}.bed TEXT=bed
	@echo "<br>" >> ${INDEX_FILE}
	@${MAKE} _link_one_file_fasta FILE=${MACS_SUBPEAKS_SUMMITS_SORTED}.fasta TEXT=fasta
#	@echo "<br>" >> ${INDEX_FILE}
	@${MAKE} _index_positions POS_SEQ_PREFIX=${MACS_PREFIX}_peaks.subpeaks_summits_sorted
	@echo "</td>" >> ${INDEX_FILE}
	@echo "</tr>" >> ${INDEX_FILE}

DISTRIB_FORMAT=pdf
_index_peak_distrib:
	@${MAKE} _link_one_file FILE=${PEAKS}_chrom_distrib.${DISTRIB_FORMAT} TEXT="chrom distrib"
	@${MAKE} _link_one_file FILE=${PEAKS}_size_distrib.${DISTRIB_FORMAT} TEXT="size distrib"
	@${MAKE} _link_one_file FILE=${PEAKS}_dist_distrib.${DISTRIB_FORMAT} TEXT="dist distr"

## Index ORI peak files
_index_ori_peaks:
	@echo
	@echo "Indexing ORI peaks"
	@echo "<a name='peaks_ori'></a><h3>ORI peaks and regions</h3>" >> ${INDEX_FILE}
	@echo "<table>"  >> ${INDEX_FILE}
	@echo "<tr valign='top'>" >> ${INDEX_FILE}
	@echo "<th>Test</th>" >> ${INDEX_FILE}
	@echo "<th>Control</th>" >> ${INDEX_FILE}
	@echo "<th>Directory</th>" >> ${INDEX_FILE}
	@echo "<th>Peaks <br>(SWEMBL peaks overlapping SICER regions)</th>" >> ${INDEX_FILE}
	@echo "<th>Peak summits<br/>(${SUMMIT_EXT} bp each side)</th>" >> ${INDEX_FILE}
	@echo "<th>Regions <br>(SICER regions overlapping SWEMBL peaks)</th>" >> ${INDEX_FILE}
	@echo "</tr>" >> ${INDEX_FILE}
	@${MAKE} iterate_analyses TASK=_index_ori_peaks_one_analysis
	@echo "</table>"  >> ${INDEX_FILE}

## Index ORI peaks for one test file
_index_ori_peaks_one_analysis:
	@echo "	Indexing ORI peaks	TEST=${TEST}	CTRL=${CTRL}	ORI_DIR=${ORI_DIR}"
	@echo "<tr valign='top'>" >> ${INDEX_FILE}
	@echo "<td>${TEST}</td>" >> ${INDEX_FILE}
	@echo "<td>${CTRL}</td>" >> ${INDEX_FILE}
	@echo "<td>" >> ${INDEX_FILE}
	@${MAKE} _link_one_file FILE=${ORI_DIR} TEXT='dir'
	@echo "</td>" >> ${INDEX_FILE}
	@echo "" >> ${INDEX_FILE}
	@echo "<td>" >> ${INDEX_FILE}
	@${MAKE} _link_one_file_lines FILE=${ORI_PEAKS}.bed TEXT=bed
	@echo "<br>" >> ${INDEX_FILE}
	@${MAKE} _link_one_file_fasta FILE=${ORI_PEAKS}.fasta TEXT=fasta
	@echo "<br>" >> ${INDEX_FILE}
	@${MAKE} _index_peak_distrib PEAKS=${ORI_PEAKS}
	@echo "</td>" >> ${INDEX_FILE}
	@echo "" >> ${INDEX_FILE}
	@echo "<td>" >> ${INDEX_FILE}
	@${MAKE} _link_one_file_lines FILE=${ORI_SUMMITS}.bed TEXT=bed
	@echo "<br>" >> ${INDEX_FILE}
	@${MAKE} _link_one_file_fasta FILE=${ORI_SUMMITS}.fasta TEXT=fasta
##	@${MAKE} _index_peak_motifs PEAK_PREFIX=${ORI_PREFIX} SUMMITS='' PEAKS=${ORI_SUMMITS}
	@${MAKE} _index_positions POS_SEQ_PREFIX=${ORI_PREFIX}_summits
	@echo "</td>" >> ${INDEX_FILE}
	@echo "" >> ${INDEX_FILE}
	@echo "<td>" >> ${INDEX_FILE}
	@${MAKE} _link_one_file_lines FILE=${ORI_REGIONS}.bed TEXT=bed
	@echo "<br>" >> ${INDEX_FILE}
	@${MAKE} _index_peak_distrib PEAKS=${ORI_REGIONS}
	@echo "</td>" >> ${INDEX_FILE}
	@echo "</tr>" >> ${INDEX_FILE}


## Index RAND peak files
_index_rand_peaks:
	@echo
	@echo "Indexing RAND peaks"
	@echo "<a name='peaks_rand'></a><h3>RAND peaks</h3>" >> ${INDEX_FILE}
	@echo "<table>"  >> ${INDEX_FILE}
	@echo "<tr valign='top'>" >> ${INDEX_FILE}
	@echo "<th>Random peaks</th>" >> ${INDEX_FILE}
	@echo "<th>Directory</th>" >> ${INDEX_FILE}
	@echo "<th>Peaks <br>(SWEMBL peaks overlapping SICER regions)</th>" >> ${INDEX_FILE}
	@echo "</tr>" >> ${INDEX_FILE}
	@${MAKE} _index_rand_peaks_one_analysis ANALYSIS=ES_indiff_C3_BN_vs_F4_RNAse
	@echo "</table>"  >> ${INDEX_FILE}


## Index RAND peaks for one test file
_index_rand_peaks_one_analysis:
	@echo "	Indexing RAND peaks	TEST=${TEST}	CTRL=${CTRL}	RAND_DIR=${RAND_DIR}"
	@echo "<tr valign='top'>" >> ${INDEX_FILE}
	@echo "<td>${RAND_PREFIX}</td>" >> ${INDEX_FILE}
	@echo "<td>" >> ${INDEX_FILE}
	@${MAKE} _link_one_file FILE=${RAND_DIR} TEXT='dir'
	@echo "</td>" >> ${INDEX_FILE}
	@echo "" >> ${INDEX_FILE}
	@echo "<td>" >> ${INDEX_FILE}
	@for rep in ${RAND_REPEATS}; do \
		${MAKE} _index_rand_peaks_one_rep RAND_REPEAT=$${rep} ; \
	done
	@echo "</td>" >> ${INDEX_FILE}
	@echo "</tr>" >> ${INDEX_FILE}

_index_rand_peaks_one_rep:
	@echo "<br>rep${RAND_REPEAT} " >> ${INDEX_FILE}
#	@echo "${RAND_PEAKS}" >> ${INDEX_FILE}
	@${MAKE} _link_one_file_lines FILE=${RAND_PEAKS}.bed TEXT=bed
	@${MAKE} _link_one_file_fasta FILE=${RAND_PEAKS}.fasta TEXT=fasta
#	@${MAKE} _index_peak_distrib PEAKS=${RAND_PEAKS}

################################################################
## Index SWEMBL peak files
_index_swembl_peaks:
	@echo
	@echo "Indexing SWEMBL peaks"
	@echo "<a name='peaks_swembl'></a><h3>SWEMBL Peaks</h3>" >> ${INDEX_FILE}
	@echo "<table>"  >> ${INDEX_FILE}
	@echo "<tr valign='top'>" >> ${INDEX_FILE}
	@echo "<th>Test</th>" >> ${INDEX_FILE}
	@echo "<th>Control</th>" >> ${INDEX_FILE}
	@echo "<th>Directory</th>" >> ${INDEX_FILE}
	@echo "<th>Peaks</th>" >> ${INDEX_FILE}
	@echo "<th>Peak summits<br/>(${SUMMIT_EXT} bp each side)</th>" >> ${INDEX_FILE}
	@echo "</tr>" >> ${INDEX_FILE}
	@${MAKE} iterate_analyses TASK=_index_swembl_peaks_one_analysis
	@echo "</table>"  >> ${INDEX_FILE}

## Index SWEMBL peaks for one test file
#SWEMBL_PEAKS_NB=`wc -l ${SWEMBL_PEAKS_SORTED}.bed | awk '{print $$1}'`
#SWEMBL_PEAKS_SIZE=`sequence-lengths -units mb -i ${SWEMBL_PEAKS_SORTED}.fasta -sum | tail -1`
#SWEMBL_SUMMITS_NB=`wc -l ${SWEMBL_SUMMITS_SORTED}.bed | awk '{print $$1}'`
#SWEMBL_SUMMITS_SIZE=`sequence-lengths -units mb -i ${SWEMBL_SUMMITS_SORTED}.fasta -sum | tail -1`
_index_swembl_peaks_one_analysis:
	@echo "	Indexing SWEMBL peaks	TEST=${TEST}	CTRL=${CTRL}	SWEMBL_PEAKS_DIR=${SWEMBL_PEAKS_DIR}"
	@echo "<tr valign='top'>" >> ${INDEX_FILE}
	@echo "<td>${TEST}</td>" >> ${INDEX_FILE}
	@echo "<td>${CTRL}</td>" >> ${INDEX_FILE}
#	@echo "<td><a href='../${SWEMBL_PEAKS_DIR}'>${SWEMBL_PEAKS_DIR}</a></td>" >> ${INDEX_FILE}
	@echo "<td>" >> ${INDEX_FILE}
	@${MAKE} _link_one_file FILE=${SWEMBL_PEAKS_DIR} TEXT='dir'
	@echo "</td><td>" >> ${INDEX_FILE}
	@${MAKE} _link_one_file_lines FILE=${SWEMBL_PEAKS_SORTED}.bed TEXT=bed
	@echo "<br>" >> ${INDEX_FILE}
	@${MAKE} _link_one_file_fasta FILE=${SWEMBL_PEAKS_SORTED}.fasta TEXT=fasta
	@echo "<br>" >> ${INDEX_FILE}
	@${MAKE} _index_peak_distrib PEAKS=${SWEMBL_PEAKS}
#	@${MAKE} _index_peak_motifs PEAK_PREFIX=${SWEMBL_PREFIX} SUMMITS='' PEAKS=${SWEMBL_PEAKS_SORTED}
	@echo "</td>" >> ${INDEX_FILE}
	@echo "" >> ${INDEX_FILE}
	@echo "<td>" >> ${INDEX_FILE}
	@${MAKE} _link_one_file_lines FILE=${SWEMBL_SUMMITS_SORTED}.bed TEXT=bed
	@echo "<br>" >> ${INDEX_FILE}
	@${MAKE} _link_one_file_fasta FILE=${SWEMBL_SUMMITS_SORTED}.fasta TEXT=fasta
#	@echo "<br>" >> ${INDEX_FILE}
##	@${MAKE} _index_peak_motifs PEAK_PREFIX=${SWEMBL_PREFIX} SUMMITS='' PEAKS=${SWEMBL_SUMMITS_SORTED}
	@${MAKE} _index_positions POS_SEQ_PREFIX=${SWEMBL_PREFIX}_summits_sorted
	@echo "</td>" >> ${INDEX_FILE}
	@echo "</tr>" >> ${INDEX_FILE}


################################################################
## Index SICER peak files
_index_sicer_regions:
	@echo
	@echo "Indexing SICER regions"
	@echo "<a name='regions_sicer'></a><h3>SICER Peaks</h3>" >> ${INDEX_FILE}
	@echo "<table>"  >> ${INDEX_FILE}
	@echo "<tr valign='top'>" >> ${INDEX_FILE}
	@echo "<th>Test</th>" >> ${INDEX_FILE}
	@echo "<th>Control</th>" >> ${INDEX_FILE}
	@echo "<th>Directory</th>" >> ${INDEX_FILE}
	@echo "<th>Peaks</th>" >> ${INDEX_FILE}
#	@echo "<th>Peak summits<br/>(${SUMMIT_EXT} bp each side)</th>" >> ${INDEX_FILE}
	@echo "</tr>" >> ${INDEX_FILE}
	@${MAKE} _index_sicer_regions_unfiltered
	@${MAKE} iterate_analyses TASK=_index_sicer_regions_one_analysis
	@echo "</table>"  >> ${INDEX_FILE}

## Index SICER regions for one test file
_index_sicer_regions_one_analysis:
	@echo "	Indexing SICER regions	TEST=${TEST}	CTRL=${CTRL}"
	@echo "<tr valign='top'>" >> ${INDEX_FILE}
	@echo "<td>${TEST}</td>" >> ${INDEX_FILE}
	@echo "<td>${CTRL}</td>" >> ${INDEX_FILE}
	@echo "<td>" >> ${INDEX_FILE}
	@${MAKE} _link_one_file FILE=${SICER_REGIONS_DIR} TEXT='dir'
	@echo "</td>" >> ${INDEX_FILE}
#	@echo "<td><a href='../${SICER_REGIONS_DIR}'>${SICER_REGIONS_DIR}</a></td>" >> ${INDEX_FILE}
	@echo "<td>" >> ${INDEX_FILE}
	@for t in ${SICER_THRESHOLD_VALUES}; do \
		${MAKE} _index_sicer_regions_one_threshold SICER_THRESHOLD=$${t}; \
	done
	@echo "</td>" >> ${INDEX_FILE}
	@echo "</tr>" >> ${INDEX_FILE}

_index_sicer_regions_unfiltered:
	@echo "<br>Unfiltered regions " >> ${INDEX_FILE}
	@${MAKE} _link_one_file_lines FILE=${SICER_SUMMARY} TEXT=bed
	@${MAKE} _index_peak_distrib PEAKS=${SICER_SUMMARY}
	@echo "<br>SICER islands (FDR <= 0.01)" >> ${INDEX_FILE}
	@${MAKE} _link_one_file_lines FILE=${SICER_ISLANDS} TEXT=bed
	@${MAKE} _index_peak_distrib PEAKS=${SICER_ISLANDS}

#SICER_REGIONS_NB=`wc -l ${SICER_SORTED}.bed | awk '{print $$1}'`
#SICER_SUMMITS_NB=`wc -l ${SICER_SUMMITS_SORTED}.bed | awk '{print $$1}'`
#SICER_REGIONS_SIZE=`sequence-lengths -units mb -i ${SICER_SORTED}.bed -in_format bed -sum | tail -1`
#SICER_SUMMITS_SIZE=`sequence-lengths -units mb -i ${SICER_SUMMITS_SORTED}.fasta -sum | tail -1`
_index_sicer_regions_one_threshold:
	@echo "<br>FDR <= ${SICER_THRESHOLD} " >> ${INDEX_FILE}
#	@echo "; ${SICER_REGIONS_NB} peaks " >> ${INDEX_FILE}
	@${MAKE} _link_one_file_lines FILE=${SICER_SORTED}.bed TEXT=bed
	@${MAKE} _index_peak_distrib PEAKS=${SICER_SUMMARY}
#	@echo "; ${SICER_REGIONS_SIZE}" >> ${INDEX_FILE}

BROWSER=Firefox
local:
	open -a ${BROWSER} ${INDEX_FILE}
