################################################################
## Synchronize the results between different computers

#include ${RSAT}/makefiles/util.mk
MAKEFILE=scripts/makefiles/synchro.mk

MAKE=make -s -f ${MAKEFILE}
SSH_OPT = -e ssh 
RSYNC_OPT= --no-g -rutvlz  ${SSH_OPT} 
RSYNC = rsync  ${RSYNC_OPT}
WGET=wget --passive-ftp -np -rNL


################################################################
#### list of targets
usage:
	@echo "usage: make [-OPT='options'] target"
	@echo "implemented targets"
	@perl -ne 'if (/^([a-z]\S+):/){ print "\t$$1\n";  }' ${MAKEFILE}

## Clean emacs ghost files
clean:
	find . -name '*~' -exec rm {} \;
	find . -name '.#*' -exec rm {} \;
	find . -name '#*#' -exec rm {} \;

PERM_DIR=.
SUDO=sudo
permissions:
	@${SUDO} find ${PERM_DIR} -type d -exec chmod 775 {} \;
	@${SUDO} find ${PERM_DIR} -type f -exec chmod 664 {} \;

## Synchronize from TAGC server to this computer
DIR=scripts
SUBDIR=`dirname ${DIR}`
EXCLUDED=--exclude *.sra \
	--exclude *.fastq \
	--exclude from_GEO \
	--exclude *.ft \
	--exclude *.sam \
	--exclude *.bam \
	--exclude 00_config.mk \
	--exclude '*~' \
	--exclude jobs \
	--exclude '*-removed.bed' \
	--exclude '*-removed.bed.gz' \
	--exclude -removed.bed \
	--exclude -islandfiltered.bed  \
	--exclude .Rproj*

#TAGC=139.124.66.4
#TAGC_DIR=replication_origins
#TAGC=139.124.66.43
#TAGC=cleopatre
#TAGC=jolitorax
#SSH_PORT=
TAGC=cleo
SSH_PORT=-p 24222
TAGC_DIR=/jolidisk/users/ballester/mechali
from_tagc:
	rsync --no-g -rutvl -z -e 'ssh ${SSH_PORT}' ${EXCLUDED} ${OPT} ${TAGC}:${TAGC_DIR}/${DIR} ${SUBDIR}
#	@${MAKE} permissions


## Get back the results from Artem about matrix-scanning
from_artem:
	rsync -ruptvl -e ssh ${EXCLUDED} --exclude '*.tab' --exclude patate.txt \
		${OPT} pedagogix:/home/artem/ori/analysis/scanning analysis/
	rsync -ruptvl -e ssh ${EXCLUDED} pedagogix:/home/artem/ori/scripts .

## Synchronize from the Web server
from_bigre_www:
	rsync --no-g -rutvl -z -e ssh ${EXCLUDED} ${OPT} jvanheld@www.bigre.ulb.ac.be:public_html/mechali/${DIR} ${SUBDIR}
#	@${MAKE} permissions

## Synchronize from this computer to TAGC server
to_tagc:
	@${MAKE} permissions
	@echo "Synchronizing ${DIR}	to TAGC"
	rsync --no-g -rutvl -z -e 'ssh ${SSH_PORT}' ${OPT} ${EXCLUDED} ${DIR} ${TAGC}:${TAGC_DIR}/${SUBDIR}

## Synchronize to a password-protected Web site
#PUB_SERVER=www.bigre.ulb.ac.be
#PUB_FOLDER=public_html/mechali
#PUB_SERVER=ori@10.1.1.212
#PUB_SERVER=ori@10.1.1.52
#PUB_SERVER=ori@pedagogix
#PUB_SERVER=ori@rsat-tagc.univ-mrs.fr
PUB_SERVER=ori@192.168.1.6
#PUB_FOLDER=Sites
PUB_FOLDER=public_html/replication_origins
NO_PUB=--exclude data/reads --exclude data/Homo_sapiens
publish:
#	@${MAKE} permissions
	@echo "Synchronizing ${DIR}	to Web server"
	rsync --no-g -rutvl -z -e ssh ${OPT} ${EXCLUDED} ${NO_PUB} ${DIR} ${PUB_SERVER}:${PUB_FOLDER}/${SUBDIR}

DIRS=index.html html scripts README.txt analysis/*  data
TASK=publish
some_dirs:
	@for d in ${DIRS} ; do \
		${MAKE} ${TASK} DIR=$${d} ; \
	done

#PUB_URL=http://www.bigre.ulb.ac.be/Users/jvanheld/mechali/
#PUB_URL=http://tagc.univ-mrs.fr/ori/
PUB_URL=http://rsat-tagc.univ-mrs.fr/ori/
BROWSER=firefox
web:
	@echo
	@echo "Web site"
	@echo "	 ${PUB_URL}"
	@open -a ${BROWSER} ${PUB_URL}


#PUB_URL=http://www.bigre.ulb.ac.be/Users/jvanheld/mechali/
LOCAL_URL=http://localhost/replication_origins/
BROWSER=firefox
local:
	@echo
	@echo "Local Web site"
	@echo "	 ${LOCAL_URL}"
	@open -a ${BROWSER} ${LOCAL_URL}
